import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo10S = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 280 193"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#997c5287__clip0_19033_1)">
            <path
                opacity={0.7}
                d="M413.265 188.781L371.413 60.4642C371.413 60.4642 365.547 20.0155 326.319 34.2322C300.015 43.7711 287.092 51.017 267.295 61.3814C259.137 65.6923 251.164 68.1687 244.656 69.728C245.573 55.2361 241.265 39.1851 225.042 38.3596C215.419 37.8093 200.113 38.9099 193.697 45.3303C198.555 31.022 182.372 11.6223 164.866 10.0631C114.379 5.56597 77.5173 41.4556 64.2276 91.4432C41.406 89.2419 18.9762 114.648 38.4067 129.324C18.1514 127.122 -19.4884 164.292 -21.2298 185.296C-21.5048 187.313 -20.13 188.781 -17.8387 188.781C10.5738 190.34 39.078 191.257 67.4905 193C79.4054 191.808 91.3203 190.34 103.144 188.506C174.175 189.056 413.265 188.781 413.265 188.781Z"
                fill="url(#997c5287__paint0_linear_19033_1)"
            />
            <path
                d="M211.742 131.019C211.63 131.019 211.519 131.006 211.41 130.978C211.242 130.937 211.084 130.863 210.945 130.76C210.806 130.657 210.689 130.528 210.6 130.381C210.511 130.233 210.453 130.069 210.428 129.898C210.403 129.728 210.412 129.554 210.455 129.387L211.431 125.657C211.523 125.321 211.744 125.035 212.046 124.859C212.349 124.683 212.708 124.632 213.048 124.717C213.216 124.759 213.374 124.833 213.513 124.935C213.652 125.038 213.77 125.167 213.858 125.315C213.947 125.463 214.006 125.627 214.03 125.797C214.055 125.968 214.046 126.141 214.003 126.308L213.027 130.038C212.952 130.32 212.785 130.569 212.553 130.746C212.32 130.924 212.035 131.02 211.742 131.019Z"
                fill="#1CB5F9"
            />
            <path
                d="M209.019 141.429C208.907 141.429 208.795 141.416 208.687 141.388C208.519 141.347 208.361 141.272 208.221 141.17C208.082 141.067 207.965 140.938 207.876 140.79C207.787 140.642 207.729 140.478 207.704 140.308C207.679 140.138 207.688 139.964 207.731 139.797L208.708 136.067C208.799 135.731 209.02 135.444 209.323 135.268C209.625 135.092 209.984 135.042 210.324 135.127C210.492 135.168 210.65 135.243 210.789 135.345C210.929 135.448 211.046 135.577 211.135 135.725C211.223 135.873 211.282 136.036 211.307 136.207C211.332 136.377 211.322 136.551 211.279 136.718L210.303 140.448C210.228 140.729 210.062 140.979 209.829 141.156C209.597 141.334 209.312 141.43 209.019 141.429Z"
                fill="#1CB5F9"
            />
            <path
                d="M218.05 136.181C217.938 136.181 217.827 136.167 217.718 136.14L213.929 135.179C213.761 135.138 213.603 135.063 213.464 134.961C213.325 134.858 213.207 134.729 213.118 134.581C213.03 134.433 212.971 134.269 212.946 134.099C212.921 133.929 212.931 133.755 212.974 133.588C213.065 133.251 213.286 132.964 213.588 132.788C213.89 132.612 214.25 132.562 214.59 132.648L218.379 133.608C218.691 133.685 218.964 133.874 219.146 134.138C219.328 134.402 219.406 134.723 219.365 135.04C219.324 135.358 219.168 135.649 218.926 135.859C218.683 136.07 218.372 136.184 218.05 136.181L218.05 136.181Z"
                fill="#1CB5F9"
            />
            <path
                d="M207.475 133.499C207.363 133.499 207.252 133.485 207.143 133.458L203.354 132.498C203.186 132.457 203.028 132.382 202.888 132.28C202.749 132.177 202.632 132.048 202.543 131.9C202.454 131.752 202.396 131.589 202.371 131.418C202.346 131.248 202.356 131.074 202.398 130.907C202.49 130.571 202.711 130.283 203.013 130.107C203.315 129.931 203.675 129.881 204.015 129.967L207.804 130.926C208.116 131.003 208.389 131.192 208.571 131.456C208.753 131.719 208.831 132.041 208.79 132.358C208.749 132.675 208.593 132.967 208.351 133.177C208.108 133.387 207.797 133.502 207.475 133.499L207.475 133.499Z"
                fill="#1CB5F9"
            />
            <path
                d="M189.116 38.9754C191.198 36.0066 192.571 34.6233 194.941 31.8277"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M194.963 39.536C196.552 38.2826 199.933 35.6031 201.523 34.3497"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M85.8673 45.3176C85.7554 45.3178 85.6439 45.3041 85.5354 45.2768C85.3673 45.2352 85.2092 45.1609 85.0701 45.0583C84.931 44.9557 84.8136 44.8267 84.7248 44.6789C84.636 44.531 84.5775 44.3671 84.5527 44.1966C84.5278 44.0261 84.5371 43.8524 84.58 43.6856L85.5562 39.9557C85.6484 39.6198 85.8693 39.3332 86.1715 39.1574C86.4737 38.9816 86.8331 38.9306 87.1727 39.0153C87.3408 39.0569 87.4989 39.1311 87.6381 39.2338C87.7772 39.3364 87.8945 39.4653 87.9833 39.6132C88.0721 39.7611 88.1306 39.925 88.1555 40.0955C88.1803 40.266 88.171 40.4396 88.1281 40.6065L87.152 44.3364C87.077 44.6181 86.9102 44.8672 86.6778 45.0447C86.4454 45.2223 86.1604 45.3182 85.8673 45.3176Z"
                fill="#1CB5F9"
            />
            <path
                d="M83.1437 55.7273C83.0318 55.7276 82.9203 55.7139 82.8118 55.6865C82.6437 55.6449 82.4856 55.5707 82.3464 55.4681C82.2073 55.3655 82.09 55.2365 82.0012 55.0886C81.9124 54.9407 81.8539 54.7768 81.829 54.6063C81.8042 54.4359 81.8135 54.2622 81.8564 54.0953L82.8325 50.3655C82.9244 50.0294 83.1452 49.7425 83.4475 49.5667C83.7498 49.3908 84.1094 49.34 84.4491 49.4251C84.6171 49.4666 84.7753 49.5409 84.9144 49.6435C85.0535 49.7461 85.1709 49.8751 85.2597 50.023C85.3485 50.1709 85.407 50.3348 85.4318 50.5052C85.4567 50.6757 85.4474 50.8494 85.4045 51.0163L84.4283 54.7461C84.3533 55.0278 84.1866 55.2769 83.9542 55.4545C83.7217 55.632 83.4367 55.7279 83.1437 55.7273Z"
                fill="#1CB5F9"
            />
            <path
                d="M92.175 50.4792C92.0631 50.4794 91.9516 50.4657 91.8432 50.4384L88.054 49.4775C87.8859 49.4359 87.7277 49.3617 87.5886 49.2591C87.4495 49.1565 87.3322 49.0275 87.2434 48.8796C87.1546 48.7317 87.0961 48.5678 87.0712 48.3973C87.0464 48.2269 87.0557 48.0532 87.0986 47.8863C87.1898 47.5498 87.4105 47.2626 87.713 47.0866C88.0155 46.9106 88.3754 46.8601 88.7151 46.9459L92.5043 47.9067C92.8165 47.9838 93.0893 48.1722 93.271 48.4362C93.4528 48.7001 93.5307 49.0213 93.4901 49.3386C93.4495 49.6559 93.2931 49.9474 93.0507 50.1577C92.8083 50.3679 92.4967 50.4823 92.175 50.4792L92.175 50.4792Z"
                fill="#1CB5F9"
            />
            <path
                d="M81.6 47.7969C81.4881 47.7972 81.3766 47.7835 81.2681 47.7561L77.4789 46.7965C77.3108 46.755 77.1526 46.6808 77.0134 46.5782C76.8743 46.4756 76.7569 46.3466 76.6681 46.1987C76.5793 46.0508 76.5208 45.8869 76.496 45.7164C76.4711 45.5459 76.4805 45.3722 76.5235 45.2053C76.6149 44.8689 76.8356 44.5817 77.138 44.4057C77.4405 44.2298 77.8004 44.1792 78.14 44.2649L81.9292 45.2244C82.2414 45.3015 82.5142 45.4899 82.696 45.7539C82.8777 46.0178 82.9556 46.3389 82.915 46.6563C82.8744 46.9736 82.718 47.2651 82.4756 47.4753C82.2332 47.6856 81.9216 47.8 81.6 47.7969L81.6 47.7969Z"
                fill="#1CB5F9"
            />
            <path
                d="M128.197 36.058C128.169 42.5942 129.361 50.2732 133.494 54.0422C133.619 54.1714 133.712 54.3271 133.767 54.4974C133.822 54.6677 133.837 54.8482 133.812 55.0253C133.787 55.2024 133.722 55.3715 133.621 55.5199C133.521 55.6682 133.388 55.792 133.232 55.8818C126.904 59.1945 121.899 64.5525 119.041 71.0731C118.958 71.2821 118.803 71.4548 118.604 71.5602C118.404 71.6656 118.174 71.6967 117.953 71.648C117.733 71.5993 117.537 71.474 117.401 71.2945C117.265 71.1151 117.198 70.8933 117.212 70.669C116.863 61.8505 114.222 54.7305 112.208 51.8424C112.11 51.6998 112.045 51.537 112.018 51.3661C111.992 51.1951 112.004 51.0205 112.055 50.855C112.105 50.6895 112.193 50.5375 112.31 50.41C112.428 50.2826 112.572 50.1831 112.734 50.1188C116.688 48.7232 122.356 43.9488 126.365 35.5993C126.45 35.3854 126.611 35.2095 126.816 35.1045C127.022 34.9994 127.259 34.9725 127.484 35.0287C127.708 35.0848 127.904 35.2202 128.035 35.4096C128.166 35.599 128.224 35.8295 128.197 36.058Z"
                fill="white"
            />
            <path
                d="M133.232 55.8876C126.902 59.1971 121.895 64.5538 119.036 71.0744C118.948 71.2994 118.776 71.4818 118.556 71.5832C118.336 71.6846 118.085 71.6971 117.855 71.6182V71.6088C118.427 70.2682 122.111 55.072 119.988 51.4909C123.444 49.7565 126.672 38.4601 127.577 35.0667C127.77 35.1492 127.933 35.2888 128.043 35.4665C128.154 35.6442 128.207 35.8515 128.195 36.0603C128.167 42.5944 129.357 50.2722 133.489 54.0502C133.614 54.1789 133.707 54.334 133.763 54.5039C133.818 54.6739 133.834 54.8541 133.81 55.0311C133.785 55.208 133.72 55.3771 133.62 55.5254C133.52 55.6738 133.387 55.7976 133.232 55.8876Z"
                fill="#D8E5FF"
            />
            <path
                d="M117.855 71.6087V71.6181C117.663 71.5452 117.498 71.4153 117.382 71.246C117.266 71.0766 117.206 70.876 117.208 70.6713C116.865 61.8497 114.218 54.7344 112.209 51.847C112.09 51.6781 112.018 51.4808 112 51.2751C114.627 51.8369 117.335 51.91 119.988 51.4909C122.111 55.0719 118.427 70.2681 117.855 71.6087Z"
                fill="#ECF1FF"
            />
            <g clipPath="url(#997c5287__clip1_19033_1)">
                <path
                    d="M186.509 82.5604L160.541 50.9321C158.093 47.9504 153.866 47.1406 150.489 49.0066L108.149 72.4038C108.149 72.4038 106.621 91.6661 104.624 109.586C104.683 111.629 109.617 111.863 111.321 112.972C118.252 117.291 132.468 126.514 168.3 124.354C170.65 124.237 174.996 125.23 175.877 123.07C177.699 115.598 181.81 102.173 186.509 82.5604Z"
                    fill="#C6D4E3"
                />
                <g
                    style={{
                        mixBlendMode: 'multiply',
                    }}
                >
                    <path
                        d="M166.166 78.1343L164.37 87.5669L144.157 136.077L141.462 133.831L166.166 78.1343Z"
                        fill="#1C508B"
                        fillOpacity={0.1}
                    />
                </g>
                <path
                    d="M167.408 38.6254C164.32 43.7003 160.238 49.2757 159.35 50.6696C160.217 51.7458 160.334 52.6406 159.92 53.4229C159.285 54.6223 157.868 55.151 156.654 54.7072C151.161 63.5024 134.985 80.0247 126.97 86.4988C128.471 88.8399 141.891 103.193 146.432 107.144C147.113 107.737 148.118 107.761 148.826 107.2C162.123 96.6535 178.889 75.7851 180.782 72.7343C180.897 72.55 180.894 72.3271 180.785 72.139C180.436 71.5306 180.137 70.3905 180.534 69.5913C181.074 68.5057 182.382 68.0486 183.71 68.1698C183.932 68.1901 184.147 68.103 184.27 67.9186C185.481 66.0988 189.869 58.0236 192.003 53.6308C192.415 52.7823 192.121 51.7686 191.318 51.2684C186.61 48.3327 174.649 40.7727 169.951 37.9882C169.072 37.4663 167.938 37.7537 167.408 38.6254Z"
                    fill="#FFCC00"
                />
                <path
                    d="M169.899 68.2604C169.984 68.0669 169.95 67.8516 169.821 67.6846C169.417 67.1604 169.043 66.195 169.224 65.3234C169.5 63.9963 170.852 63.4108 172.204 63.3686C172.429 63.3616 172.634 63.2451 172.731 63.0423C173.656 61.112 176.595 52.9441 178.059 48.4132C178.345 47.5283 177.924 46.5766 177.075 46.1885C173.188 44.4094 164.642 40.4401 158.634 37.7249C156.27 42.1158 153.728 46.2904 153.096 47.4883C154.048 48.4908 154.238 49.3731 153.889 50.1863C153.354 51.4332 151.986 52.0749 150.74 51.7308C145.983 60.9417 131.213 78.7198 123.754 85.8217C125.39 87.9669 139.124 100.463 144.374 104.471C157.295 90.6821 168.434 71.6019 169.899 68.2604Z"
                    fill="#EBB409"
                />
                <path
                    d="M148.653 35.7472C146.74 40.8239 144.345 46.1466 143.524 48.0812C143.43 48.3031 143.494 48.5488 143.663 48.7217C144.471 49.5482 144.685 50.4188 144.382 51.1553C143.973 52.1502 143.009 52.667 141.771 52.8566C141.569 52.8877 141.397 53.0117 141.32 53.2001C137.553 62.4027 125.517 80.0721 118.576 88.6378C117.929 89.4371 118.056 90.6002 118.861 91.2411C123.411 94.8671 136.36 103.767 140.75 106.198C141.462 106.592 142.496 106.419 143.037 105.813C156.002 91.2729 167.072 69.9203 168.426 66.3479C168.5 66.1505 168.456 65.937 168.318 65.7766C167.888 65.2733 167.465 64.3284 167.602 63.4489C167.81 62.1096 169.13 61.4571 170.477 61.3461C170.702 61.3276 170.9 61.2009 170.987 60.9937C171.811 59.0194 174.33 50.7137 175.56 46.1152C175.801 45.2172 175.332 44.2878 174.465 43.9429C169.319 41.8952 156.172 36.57 151.041 34.6598C150.08 34.3008 149.013 34.7905 148.653 35.7472Z"
                    fill="url(#997c5287__paint1_linear_19033_1)"
                />
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M148.807 69.2783C151.778 71.0075 153.625 73.2796 152.069 76.0486C150.513 78.8174 147.542 78.2861 144.571 76.5569C141.6 74.8277 139.706 72.5099 141.309 69.7867C142.912 67.0634 145.835 67.5491 148.807 69.2783ZM147.6 71.3836C149.663 72.5841 151.234 73.7001 150.438 75.0994C149.642 76.4988 147.868 75.6683 145.805 74.4678C143.742 73.2673 142.168 72.0943 142.967 70.752C143.767 69.4097 145.537 70.1831 147.6 71.3836Z"
                    fill="white"
                />
                <path
                    d="M137.279 82.5449L139.225 83.6776L138.814 79.4016L147.149 84.2516L148.393 82.1132L137.893 76.0029L136.8 77.8808L137.279 82.5449Z"
                    fill="white"
                />
                <path
                    d="M138.697 90.3245L137.038 89.3592L139.136 85.7543L140.795 86.7195L138.697 90.3245Z"
                    fill="white"
                />
                <path
                    d="M155.154 70.678L155.723 69.7009L151.55 61.7494L150.982 62.726L155.154 70.678Z"
                    fill="white"
                />
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M152.488 67.8418C153.013 66.959 152.531 66.0519 151.61 65.5162C150.69 64.9805 149.656 65.039 149.154 65.9018C148.652 66.7645 149.112 67.6918 150.032 68.2275C150.953 68.7632 151.963 68.7246 152.488 67.8418ZM151.769 67.4234C151.951 67.1079 151.578 66.7923 151.064 66.4929C150.549 66.1934 150.1 66.0068 149.906 66.3392C149.711 66.6717 150.097 66.9704 150.611 67.2699C151.126 67.5693 151.587 67.7392 151.769 67.4234Z"
                    fill="white"
                />
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M156.724 64.217C157.644 64.7528 158.126 65.6599 157.601 66.5428C157.077 67.4256 156.066 67.4641 155.146 66.9283C154.225 66.3926 153.766 65.4654 154.268 64.6027C154.77 63.74 155.803 63.6813 156.724 64.217ZM156.177 65.1938C156.692 65.4932 157.065 65.8089 156.883 66.1244C156.7 66.44 156.239 66.2702 155.725 65.9708C155.21 65.6714 154.825 65.3726 155.019 65.0401C155.214 64.7077 155.662 64.8944 156.177 65.1938Z"
                    fill="white"
                />
                <path
                    d="M147.889 52.2724C148.259 52.486 148.384 52.9586 148.169 53.3275C148.072 53.4928 147.923 53.6091 147.755 53.6681C147.548 53.7409 147.311 53.7263 147.107 53.6082C146.74 53.3958 146.586 52.9151 146.795 52.5474C147.003 52.1791 147.443 52.0307 147.816 52.2324L147.443 52.9103L147.826 52.2381C147.832 52.2411 147.882 52.2688 147.889 52.2724ZM154.632 55.4173C154.243 55.2374 153.781 55.4035 153.599 55.7913C153.417 56.1777 153.585 56.6372 153.974 56.817L154.053 56.8527C154.239 56.9321 154.439 56.9332 154.617 56.8709C154.814 56.8017 154.984 56.6532 155.073 56.4471C155.242 56.0547 155.061 55.6012 154.666 55.4333L154.632 55.4173ZM150.852 54.5589L151.181 53.8589C150.792 53.679 150.33 53.8451 150.148 54.2329C149.966 54.6193 150.134 55.0788 150.523 55.2586C150.528 55.2614 150.589 55.2891 150.594 55.2911C150.782 55.3738 150.985 55.3759 151.165 55.3128C151.361 55.2443 151.528 55.0984 151.618 54.8954C151.792 54.5053 151.615 54.0498 151.222 53.8779L150.852 54.5589ZM158.077 56.9875C157.689 56.8068 157.25 56.9854 157.069 57.373C156.887 57.7594 157.079 58.2295 157.468 58.41C157.661 58.5019 157.874 58.5072 158.061 58.4414C158.249 58.3756 158.411 58.2388 158.504 58.0465C158.69 57.662 158.527 57.2013 158.14 57.0169L158.077 56.9875ZM164.975 60.3999C164.969 60.3963 164.908 60.3628 164.9 60.3588C164.526 60.1623 164.088 60.3133 163.883 60.6837C163.677 61.0535 163.836 61.532 164.204 61.7414C164.408 61.8564 164.642 61.8704 164.847 61.7985C165.017 61.7389 165.167 61.6202 165.263 61.4529C165.477 61.0822 165.348 60.611 164.975 60.3999ZM161.504 58.6178C161.121 58.4359 160.69 58.6067 160.5 58.984C160.311 59.3614 160.489 59.8331 160.866 60.0269C161.064 60.1289 161.285 60.1375 161.481 60.0691C161.661 60.006 161.818 59.8774 161.913 59.6957C162.11 59.3162 161.962 58.8505 161.581 58.6548C161.573 58.6516 161.51 58.6207 161.504 58.6178Z"
                    fill="#891712"
                />
                <path
                    d="M186.509 82.5604L145.273 98.2624C143.746 98.8461 142.042 98.6126 140.75 97.6203L108.149 72.4038C108.149 72.4038 105.447 90.499 104.624 109.586C104.683 111.629 105.799 113.497 107.502 114.606C117.489 119.685 140.75 126.864 170.649 126.864C172.999 126.748 175.055 125.288 175.936 123.129C178.58 115.599 182.104 103.633 186.509 82.5604Z"
                    fill="#D4E0ED"
                />
            </g>
            <path
                d="M180.712 103.961C180.687 109.898 181.77 116.874 185.524 120.297C185.637 120.414 185.722 120.556 185.772 120.711C185.822 120.865 185.836 121.029 185.813 121.19C185.79 121.351 185.73 121.505 185.639 121.639C185.548 121.774 185.427 121.887 185.286 121.968C179.538 124.977 174.991 129.844 172.396 135.767C172.32 135.957 172.179 136.114 171.998 136.21C171.817 136.305 171.607 136.334 171.407 136.289C171.207 136.245 171.029 136.131 170.905 135.968C170.782 135.805 170.721 135.604 170.733 135.4C170.417 127.39 168.018 120.922 166.188 118.299C166.099 118.169 166.04 118.021 166.016 117.866C165.992 117.711 166.003 117.552 166.049 117.402C166.095 117.252 166.174 117.114 166.281 116.998C166.388 116.882 166.519 116.792 166.666 116.733C170.257 115.466 175.407 111.129 179.048 103.544C179.125 103.35 179.271 103.19 179.458 103.095C179.645 102.999 179.86 102.975 180.064 103.026C180.268 103.077 180.446 103.2 180.565 103.372C180.684 103.544 180.737 103.753 180.712 103.961Z"
                fill="white"
            />
            <path
                d="M185.286 121.973C179.536 124.98 174.988 129.845 172.391 135.768C172.311 135.973 172.155 136.138 171.955 136.231C171.755 136.323 171.527 136.334 171.318 136.262V136.254C171.837 135.036 175.184 121.232 173.256 117.98C176.395 116.404 179.327 106.143 180.149 103.061C180.324 103.136 180.472 103.262 180.573 103.424C180.673 103.585 180.721 103.773 180.711 103.963C180.685 109.898 181.766 116.873 185.519 120.304C185.633 120.421 185.718 120.562 185.768 120.717C185.818 120.871 185.833 121.035 185.81 121.195C185.788 121.356 185.729 121.51 185.638 121.644C185.547 121.779 185.427 121.892 185.286 121.973Z"
                fill="#D8E5FF"
            />
            <path
                d="M171.319 136.254V136.262C171.144 136.196 170.994 136.078 170.889 135.924C170.784 135.77 170.728 135.588 170.731 135.402C170.419 127.389 168.015 120.926 166.19 118.303C166.082 118.15 166.016 117.971 166 117.784C168.386 118.294 170.846 118.36 173.256 117.98C175.185 121.232 171.838 135.036 171.319 136.254Z"
                fill="#ECF1FF"
            />
        </g>
        <defs>
            <linearGradient
                id="997c5287__paint0_linear_19033_1"
                x1={143.5}
                y1={10}
                x2={139.613}
                y2={355.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.230015} stopColor="#F2F6FB" />
                <stop offset={0.498302} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="997c5287__paint1_linear_19033_1"
                x1={141.088}
                y1={105.21}
                x2={153.663}
                y2={35.8834}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="997c5287__clip0_19033_1">
                <path
                    d="M0 8C0 3.58173 3.58172 0 8 0H272C276.418 0 280 3.58172 280 8V185C280 189.418 276.418 193 272 193H8C3.58172 193 0 189.418 0 185V8Z"
                    fill="white"
                />
            </clipPath>
            <clipPath id="997c5287__clip1_19033_1">
                <rect
                    width={87}
                    height={94}
                    fill="white"
                    transform="translate(105 33)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default Promo10S;
