import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo10Xs = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 137 102"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#4fc3b553__clip0_19033_0)">
            <path
                opacity={0.5}
                d="M233.483 111.094L211.022 36.5149C211.022 36.5149 207.874 13.0055 186.821 21.2684C172.704 26.8126 165.769 31.024 155.144 37.048C150.766 39.5535 146.487 40.9929 142.995 41.8991C143.486 33.4763 141.175 24.1471 132.468 23.6674C127.304 23.3475 119.089 23.9872 115.646 27.7189C118.253 19.4026 109.568 8.12726 100.173 7.221C73.0777 4.6072 53.2952 25.4668 46.1629 54.5203C33.9151 53.2409 21.8776 68.0076 32.3055 76.537C21.4349 75.2576 1.2345 96.8609 0.29993 109.069C0.152366 110.242 0.890187 111.095 2.11989 111.095C17.3682 112.001 32.6657 112.534 47.914 113.547C54.3085 112.854 60.7029 112.001 67.0482 110.935C105.169 111.254 233.483 111.094 233.483 111.094Z"
                fill="url(#4fc3b553__paint0_linear_19033_0)"
            />
            <path
                d="M84.3451 29.7218C84.3261 34.1807 85.1395 39.4194 87.959 41.9906C88.0438 42.0788 88.1074 42.185 88.1449 42.3011C88.1825 42.4173 88.193 42.5405 88.1758 42.6613C88.1586 42.7821 88.114 42.8975 88.0455 42.9987C87.9769 43.0999 87.8862 43.1843 87.7801 43.2456C83.4632 45.5055 80.0487 49.1607 78.0991 53.6091C78.0425 53.7517 77.9367 53.8695 77.8006 53.9414C77.6645 54.0133 77.5071 54.0345 77.3567 54.0013C77.2063 53.9681 77.0727 53.8826 76.98 53.7602C76.8872 53.6377 76.8415 53.4864 76.8508 53.3334C76.6131 47.3175 74.8115 42.4602 73.4374 40.4899C73.3703 40.3926 73.3261 40.2815 73.3081 40.1649C73.29 40.0483 73.2985 39.9292 73.3329 39.8163C73.3674 39.7034 73.4269 39.5997 73.5071 39.5127C73.5872 39.4258 73.686 39.3579 73.7961 39.3141C76.4934 38.362 80.3607 35.1049 83.0955 29.4089C83.1534 29.2629 83.2628 29.1429 83.4032 29.0713C83.5436 28.9996 83.7054 28.9812 83.8584 29.0196C84.0114 29.0579 84.1451 29.1502 84.2347 29.2795C84.3243 29.4087 84.3635 29.5659 84.3451 29.7218Z"
                fill="white"
            />
            <path
                d="M87.781 43.2495C83.4626 45.5072 80.0467 49.1616 78.0964 53.6099C78.0365 53.7634 77.9192 53.8878 77.7689 53.957C77.6187 54.0262 77.4474 54.0348 77.291 53.9809V53.9745C77.6808 53.0599 80.1944 42.6931 78.746 40.2501C81.1038 39.0669 83.3057 31.3604 83.9228 29.0454C84.0545 29.1017 84.1657 29.1969 84.2412 29.3182C84.3167 29.4394 84.3529 29.5809 84.345 29.7233C84.3255 34.1808 85.1374 39.4187 87.9564 41.996C88.0414 42.0838 88.1052 42.1896 88.1431 42.3055C88.181 42.4215 88.1919 42.5444 88.175 42.6651C88.1581 42.7859 88.1139 42.9012 88.0456 43.0024C87.9774 43.1036 87.8869 43.1881 87.781 43.2495Z"
                fill="#D8E5FF"
            />
            <path
                d="M77.2905 53.9741V53.9805C77.1593 53.9308 77.0465 53.8422 76.9676 53.7266C76.8886 53.6111 76.8471 53.4743 76.8488 53.3346C76.615 47.3165 74.8093 42.4625 73.4388 40.4926C73.3573 40.3775 73.308 40.2429 73.2959 40.1025C75.0877 40.4857 76.9354 40.5356 78.7455 40.2497C80.1939 42.6927 77.6803 53.0595 77.2905 53.9741Z"
                fill="#ECF1FF"
            />
            <path
                d="M124.758 59.8859L107.403 38.6456C104.953 35.6477 100.709 34.8339 97.3241 36.7133L68.7337 52.5891C68.7337 52.5891 67.6419 66.4277 66.2139 79.302C66.2559 80.7698 69.7838 80.9374 71.0017 81.7341C75.9573 84.8374 86.1206 91.4632 111.739 89.9115C113.419 89.8277 116.526 90.5407 117.156 88.9891C118.458 83.6212 121.398 73.9761 124.758 59.8859Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M102.717 51.0173L101.652 56.6051L89.6785 85.3419L88.082 84.0115L102.717 51.0173Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M111.1 28.3222C108.892 31.9681 105.973 35.9736 105.339 36.975C105.959 37.7482 106.043 38.391 105.746 38.9531C105.292 39.8147 104.28 40.1945 103.411 39.8757C99.4842 46.1944 87.9194 58.0645 82.1889 62.7156C83.2618 64.3975 92.8566 74.7089 96.1031 77.5474C96.5903 77.9734 97.3084 77.9908 97.8147 77.5875C107.321 70.0109 119.308 55.0186 120.662 52.8268C120.744 52.6944 120.742 52.5343 120.664 52.3992C120.414 51.9621 120.2 51.143 120.485 50.5688C120.87 49.7889 121.806 49.4605 122.755 49.5476C122.914 49.5622 123.068 49.4996 123.155 49.3671C124.021 48.0598 127.159 42.2583 128.684 39.1024C128.979 38.4928 128.769 37.7646 128.195 37.4052C124.828 35.2961 116.277 29.8648 112.918 27.8644C112.289 27.4894 111.479 27.6959 111.1 28.3222Z"
                fill="#FFCC00"
            />
            <path
                d="M112.881 49.6125C112.941 49.4736 112.918 49.3189 112.825 49.1989C112.536 48.8223 112.269 48.1288 112.398 47.5026C112.596 46.5492 113.562 46.1285 114.529 46.0982C114.69 46.0932 114.836 46.0095 114.906 45.8638C115.567 44.477 117.668 38.609 118.715 35.3539C118.919 34.7181 118.618 34.0344 118.011 33.7556C115.233 32.4775 109.122 29.6258 104.827 27.6752C103.137 30.8297 101.319 33.8288 100.868 34.6894C101.548 35.4096 101.684 36.0435 101.435 36.6277C101.052 37.5235 100.074 37.9845 99.1829 37.7373C95.7824 44.3547 85.2224 57.1268 79.8896 62.2291C81.0595 63.7702 90.878 72.7474 94.6319 75.6271C103.869 65.7209 111.834 52.0132 112.881 49.6125Z"
                fill="#EBB409"
            />
            <path
                d="M97.6906 26.2543C96.3229 29.9015 94.6103 33.7255 94.0239 35.1153C93.9567 35.2748 94.0023 35.4513 94.1227 35.5755C94.7006 36.1693 94.8535 36.7948 94.6368 37.3239C94.3444 38.0386 93.6556 38.4099 92.7701 38.5461C92.6259 38.5684 92.5028 38.6575 92.4478 38.7929C89.7544 45.4042 81.1492 58.0984 76.1874 64.2521C75.7246 64.8264 75.8153 65.662 76.3909 66.1225C79.6436 68.7274 88.9014 75.121 92.04 76.8677C92.5493 77.1511 93.2885 77.0267 93.6753 76.5909C102.945 66.1453 110.859 50.8051 111.827 48.2386C111.88 48.0968 111.848 47.9433 111.75 47.8281C111.443 47.4665 111.14 46.7877 111.238 46.1558C111.386 45.1937 112.33 44.7249 113.294 44.6451C113.454 44.6319 113.596 44.5408 113.658 44.392C114.248 42.9736 116.048 37.0066 116.928 33.7029C117.1 33.0578 116.765 32.3901 116.144 32.1423C112.466 30.6712 103.066 26.8454 99.3981 25.4731C98.7111 25.2151 97.9481 25.5669 97.6906 26.2543Z"
                fill="url(#4fc3b553__paint1_linear_19033_0)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M97.7653 50.0869C99.7992 51.2705 101.064 52.8258 99.9983 54.7211C98.9331 56.6164 96.8999 56.2527 94.866 55.0691C92.8321 53.8855 91.5356 52.2989 92.633 50.4349C93.7302 48.5708 95.7314 48.9033 97.7653 50.0869ZM96.9392 51.528C98.3513 52.3497 99.4266 53.1136 98.8817 54.0714C98.3369 55.0293 97.1228 54.4608 95.7107 53.6391C94.2986 52.8174 93.2209 52.0144 93.7682 51.0957C94.3154 50.1769 95.5271 50.7062 96.9392 51.528Z"
                fill="white"
            />
            <path
                d="M89.8745 59.1678L91.2069 59.9431L90.9256 57.0163L96.6303 60.336L97.4821 58.8723L90.2949 54.6899L89.5469 55.9753L89.8745 59.1678Z"
                fill="white"
            />
            <path
                d="M90.8452 64.4929L89.7098 63.8322L91.1458 61.3646L92.2811 62.0253L90.8452 64.4929Z"
                fill="white"
            />
            <path
                d="M102.11 51.045L102.499 50.3762L99.643 44.9334L99.254 45.6019L102.11 51.045Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M100.285 49.1036C100.645 48.4994 100.314 47.8785 99.6842 47.5118C99.054 47.1451 98.3469 47.1852 98.0032 47.7757C97.6595 48.3663 97.974 49.0009 98.6042 49.3676C99.2343 49.7343 99.9257 49.7079 100.285 49.1036ZM99.7929 48.8173C99.9179 48.6013 99.6622 48.3853 99.3101 48.1803C98.9578 47.9753 98.6508 47.8476 98.5177 48.0751C98.3844 48.3027 98.6483 48.5072 99.0006 48.7122C99.3527 48.9171 99.6682 49.0334 99.7929 48.8173Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M103.184 46.6225C103.814 46.9892 104.145 47.6101 103.785 48.2145C103.426 48.8187 102.734 48.8451 102.104 48.4784C101.474 48.1117 101.16 47.477 101.503 46.8865C101.847 46.296 102.554 46.2558 103.184 46.6225ZM102.81 47.2911C103.162 47.496 103.418 47.7121 103.293 47.9281C103.168 48.1441 102.853 48.0279 102.501 47.823C102.149 47.618 101.885 47.4134 102.018 47.1859C102.151 46.9584 102.458 47.0861 102.81 47.2911Z"
                fill="white"
            />
            <path
                d="M97.7392 37.8764C98.0089 38.0218 98.1086 38.3585 97.9628 38.6279C97.8976 38.7488 97.7939 38.8354 97.675 38.8814C97.5283 38.9381 97.3591 38.9327 97.2103 38.8523C96.9434 38.7078 96.8225 38.3659 96.9635 38.0974C97.1043 37.8284 97.4153 37.7125 97.6863 37.8492L97.4352 38.344L97.6936 37.8531C97.6981 37.8551 97.7345 37.8739 97.7392 37.8764ZM102.628 39.9895C102.347 39.8687 102.02 39.9979 101.899 40.2802C101.777 40.5616 101.907 40.888 102.189 41.0087L102.247 41.0326C102.382 41.0856 102.525 41.0821 102.65 41.0336C102.79 40.9796 102.908 40.8693 102.967 40.7194C103.079 40.434 102.939 40.1123 102.653 40.0002L102.628 39.9895ZM99.9077 39.4544L100.127 38.9448C99.8458 38.8239 99.519 38.9531 99.3977 39.2355C99.2765 39.5168 99.4065 39.8432 99.6885 39.9639C99.6921 39.9658 99.7364 39.9844 99.7403 39.9857C99.8765 40.041 100.022 40.0382 100.149 39.989C100.287 39.9356 100.403 39.8273 100.463 39.6796C100.579 39.3957 100.442 39.0725 100.157 38.9575L99.9077 39.4544ZM105.125 41.0429C104.844 40.9215 104.535 41.0591 104.414 41.3413C104.293 41.6226 104.44 41.9561 104.722 42.0773C104.862 42.1392 105.014 42.1384 105.147 42.0871C105.28 42.0358 105.393 41.9341 105.455 41.794C105.579 41.5139 105.452 41.1867 105.172 41.0626L105.125 41.0429ZM110.132 43.3447C110.127 43.3422 110.083 43.3195 110.077 43.3168C109.805 43.1837 109.495 43.3016 109.357 43.5719C109.219 43.8419 109.343 44.1821 109.61 44.3245C109.759 44.4027 109.926 44.4077 110.071 44.3517C110.191 44.3052 110.296 44.2168 110.361 44.0946C110.505 43.8238 110.403 43.4882 110.132 43.3447ZM107.611 42.1398C107.333 42.0173 107.029 42.1493 106.902 42.4243C106.775 42.6993 106.913 43.0342 107.186 43.1653C107.33 43.2342 107.489 43.2356 107.627 43.1823C107.754 43.1331 107.864 43.0374 107.927 42.9049C108.06 42.6282 107.944 42.2969 107.667 42.1646C107.662 42.1625 107.616 42.1416 107.611 42.1398Z"
                fill="#891712"
            />
            <path
                d="M124.758 59.8861L95.2758 71.1668C94.1838 71.5861 92.9659 71.4184 92.042 70.7055L68.7337 52.5894C68.7337 52.5894 66.802 65.5894 66.2139 79.3023C66.2559 80.77 67.0538 82.1119 68.2717 82.9087C75.4114 86.5571 92.042 91.7152 113.418 91.7152C115.098 91.6313 116.568 90.5829 117.198 89.0313C119.088 83.6216 121.608 75.0248 124.758 59.8861Z"
                fill="#D4E0ED"
            />
            <path
                d="M120.173 76.0453C120.155 80.0956 120.894 84.8542 123.455 87.1897C123.532 87.2698 123.59 87.3663 123.624 87.4718C123.658 87.5773 123.668 87.6892 123.652 87.799C123.637 87.9087 123.596 88.0135 123.534 88.1054C123.472 88.1974 123.389 88.274 123.293 88.3297C119.371 90.3825 116.27 93.7028 114.499 97.7435C114.448 97.873 114.352 97.98 114.228 98.0453C114.104 98.1106 113.961 98.1299 113.825 98.0997C113.688 98.0696 113.567 97.9919 113.482 97.8807C113.398 97.7695 113.357 97.632 113.365 97.493C113.149 92.0284 111.513 87.6163 110.265 85.8266C110.204 85.7382 110.163 85.6373 110.147 85.5314C110.131 85.4255 110.138 85.3172 110.17 85.2147C110.201 85.1122 110.255 85.0179 110.328 84.939C110.401 84.86 110.49 84.7983 110.59 84.7585C113.04 83.8937 116.553 80.9351 119.037 75.761C119.09 75.6285 119.19 75.5194 119.317 75.4544C119.445 75.3893 119.592 75.3726 119.73 75.4074C119.869 75.4422 119.991 75.5261 120.072 75.6435C120.154 75.7609 120.189 75.9037 120.173 76.0453Z"
                fill="white"
            />
            <path
                d="M123.292 88.3332C119.37 90.3841 116.267 93.7035 114.495 97.7442C114.441 97.8836 114.334 97.9967 114.198 98.0595C114.061 98.1224 113.906 98.1301 113.764 98.0812V98.0754C114.118 97.2446 116.401 87.8278 115.085 85.6087C117.227 84.5339 119.227 77.5338 119.788 75.4309C119.907 75.4821 120.008 75.5686 120.077 75.6787C120.145 75.7888 120.178 75.9173 120.171 76.0466C120.153 80.0957 120.891 84.8535 123.452 87.1947C123.529 87.2744 123.587 87.3705 123.621 87.4758C123.656 87.5811 123.666 87.6928 123.65 87.8025C123.635 87.9121 123.595 88.0169 123.533 88.1088C123.471 88.2008 123.388 88.2775 123.292 88.3332Z"
                fill="#D8E5FF"
            />
            <path
                d="M113.764 98.0752V98.081C113.645 98.0358 113.543 97.9553 113.471 97.8504C113.399 97.7455 113.362 97.6211 113.363 97.4943C113.151 92.0277 111.51 87.6185 110.266 85.8292C110.192 85.7246 110.147 85.6023 110.136 85.4749C111.763 85.8229 113.442 85.8683 115.086 85.6085C116.402 87.8276 114.118 97.2444 113.764 98.0752Z"
                fill="#ECF1FF"
            />
            <path
                d="M118.709 26.5477C120.616 23.8281 121.873 22.561 124.045 20.0001"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M124.065 27.0615C125.521 25.9134 128.618 23.4588 130.074 22.3107"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M57.6955 29.6874C57.648 29.6875 57.6007 29.6816 57.5546 29.6699C57.4833 29.652 57.4162 29.62 57.3572 29.5759C57.2981 29.5317 57.2483 29.4762 57.2107 29.4126C57.173 29.349 57.1481 29.2784 57.1376 29.2051C57.1271 29.1317 57.131 29.057 57.1492 28.9852L57.5634 27.3803C57.6026 27.2358 57.6963 27.1125 57.8246 27.0368C57.9528 26.9612 58.1053 26.9393 58.2494 26.9757C58.3207 26.9936 58.3879 27.0255 58.4469 27.0697C58.5059 27.1138 58.5557 27.1693 58.5934 27.233C58.6311 27.2966 58.6559 27.3671 58.6665 27.4405C58.677 27.5138 58.6731 27.5886 58.6548 27.6604L58.2406 29.2652C58.2088 29.3865 58.138 29.4937 58.0394 29.57C57.9408 29.6464 57.8198 29.6877 57.6955 29.6874Z"
                fill="#1CB5F9"
            />
            <path
                d="M56.5392 34.1666C56.4917 34.1667 56.4444 34.1608 56.3984 34.149C56.3271 34.1311 56.26 34.0992 56.2009 34.055C56.1419 34.0109 56.0921 33.9554 56.0544 33.8918C56.0167 33.8281 55.9919 33.7576 55.9814 33.6842C55.9708 33.6109 55.9748 33.5362 55.993 33.4644L56.4072 31.8595C56.4462 31.7149 56.5399 31.5914 56.6682 31.5158C56.7964 31.4401 56.949 31.4182 57.0932 31.4548C57.1645 31.4727 57.2316 31.5047 57.2906 31.5488C57.3497 31.593 57.3995 31.6485 57.4371 31.7121C57.4748 31.7757 57.4996 31.8463 57.5102 31.9196C57.5207 31.993 57.5168 32.0677 57.4986 32.1395L57.0844 33.7444C57.0525 33.8656 56.9818 33.9728 56.8832 34.0492C56.7845 34.1256 56.6636 34.1668 56.5392 34.1666Z"
                fill="#1CB5F9"
            />
            <path
                d="M60.3727 31.9085C60.3252 31.9086 60.2779 31.9027 60.2319 31.8909L58.624 31.4775C58.5527 31.4596 58.4855 31.4277 58.4265 31.3835C58.3675 31.3394 58.3177 31.2839 58.28 31.2202C58.2423 31.1566 58.2175 31.0861 58.2069 31.0127C58.1964 30.9394 58.2003 30.8646 58.2185 30.7928C58.2573 30.648 58.3509 30.5244 58.4793 30.4487C58.6076 30.373 58.7604 30.3513 58.9045 30.3882L60.5124 30.8016C60.6449 30.8348 60.7607 30.9159 60.8378 31.0294C60.9149 31.143 60.948 31.2812 60.9308 31.4177C60.9135 31.5543 60.8472 31.6797 60.7443 31.7701C60.6414 31.8606 60.5092 31.9099 60.3727 31.9085L60.3727 31.9085Z"
                fill="#1CB5F9"
            />
            <path
                d="M55.8845 30.7543C55.837 30.7545 55.7897 30.7486 55.7437 30.7368L54.1358 30.3239C54.0644 30.306 53.9973 30.2741 53.9382 30.23C53.8792 30.1858 53.8294 30.1303 53.7917 30.0667C53.754 30.003 53.7292 29.9325 53.7186 29.8591C53.7081 29.7858 53.7121 29.711 53.7303 29.6392C53.7691 29.4945 53.8628 29.3709 53.9911 29.2952C54.1194 29.2195 54.2722 29.1977 54.4163 29.2346L56.0242 29.6474C56.1567 29.6806 56.2725 29.7617 56.3496 29.8753C56.4267 29.9888 56.4598 30.127 56.4425 30.2635C56.4253 30.4001 56.359 30.5255 56.2561 30.616C56.1532 30.7064 56.021 30.7557 55.8845 30.7543L55.8845 30.7543Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.465 92.7289C132.418 92.7291 132.37 92.7232 132.324 92.7114C132.253 92.6935 132.186 92.6615 132.127 92.6174C132.068 92.5732 132.018 92.5177 131.98 92.4541C131.943 92.3905 131.918 92.32 131.907 92.2466C131.897 92.1732 131.901 92.0985 131.919 92.0267L132.333 90.4218C132.372 90.2773 132.466 90.154 132.594 90.0784C132.722 90.0027 132.875 89.9808 133.019 90.0172C133.09 90.0351 133.157 90.067 133.216 90.1112C133.275 90.1553 133.325 90.2108 133.363 90.2745C133.401 90.3381 133.425 90.4086 133.436 90.482C133.447 90.5553 133.443 90.6301 133.424 90.7019L133.01 92.3067C132.978 92.428 132.908 92.5352 132.809 92.6115C132.71 92.6879 132.589 92.7292 132.465 92.7289Z"
                fill="#1CB5F9"
            />
            <path
                d="M131.309 97.2081C131.261 97.2082 131.214 97.2023 131.168 97.1905C131.097 97.1726 131.029 97.1407 130.97 97.0965C130.911 97.0524 130.862 96.9969 130.824 96.9333C130.786 96.8696 130.761 96.7991 130.751 96.7257C130.74 96.6524 130.744 96.5777 130.762 96.5059L131.177 94.901C131.216 94.7564 131.309 94.633 131.438 94.5573C131.566 94.4816 131.719 94.4597 131.863 94.4963C131.934 94.5142 132.001 94.5462 132.06 94.5903C132.119 94.6345 132.169 94.69 132.207 94.7536C132.244 94.8172 132.269 94.8878 132.28 94.9611C132.29 95.0345 132.286 95.1092 132.268 95.181L131.854 96.7859C131.822 96.9071 131.751 97.0143 131.653 97.0907C131.554 97.1671 131.433 97.2083 131.309 97.2081Z"
                fill="#1CB5F9"
            />
            <path
                d="M135.142 94.95C135.095 94.9501 135.047 94.9442 135.001 94.9324L133.394 94.519C133.322 94.5011 133.255 94.4692 133.196 94.425C133.137 94.3809 133.087 94.3254 133.05 94.2617C133.012 94.1981 132.987 94.1276 132.976 94.0542C132.966 93.9809 132.97 93.9061 132.988 93.8343C133.027 93.6895 133.12 93.5659 133.249 93.4902C133.377 93.4145 133.53 93.3928 133.674 93.4297L135.282 93.8431C135.414 93.8763 135.53 93.9574 135.607 94.0709C135.684 94.1845 135.718 94.3227 135.7 94.4592C135.683 94.5958 135.617 94.7212 135.514 94.8117C135.411 94.9021 135.279 94.9514 135.142 94.95L135.142 94.95Z"
                fill="#1CB5F9"
            />
            <path
                d="M130.654 93.7958C130.607 93.796 130.559 93.7901 130.513 93.7783L128.905 93.3654C128.834 93.3475 128.767 93.3156 128.708 93.2715C128.649 93.2273 128.599 93.1718 128.561 93.1082C128.524 93.0445 128.499 92.974 128.488 92.9006C128.478 92.8273 128.482 92.7525 128.5 92.6807C128.539 92.536 128.632 92.4124 128.761 92.3367C128.889 92.261 129.042 92.2392 129.186 92.2761L130.794 92.6889C130.926 92.7221 131.042 92.8032 131.119 92.9168C131.196 93.0303 131.229 93.1685 131.212 93.3051C131.195 93.4416 131.128 93.567 131.026 93.6575C130.923 93.7479 130.791 93.7972 130.654 93.7958L130.654 93.7958Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="4fc3b553__paint0_linear_19033_0"
                x1={66.5748}
                y1={12.8891}
                x2={84.6034}
                y2={92.4098}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.393875} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="4fc3b553__paint1_linear_19033_0"
                x1={92.2822}
                y1={76.1581}
                x2={101.357}
                y2={26.3676}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="4fc3b553__clip0_19033_0">
                <rect width={137} height={102} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default Promo10Xs;
