import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Promo500M = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 307 180"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#06744177__clip0_19033_10)">
            <g opacity={0.6}>
                <path
                    d="M508 225.96L459.071 72.666C459.071 72.666 452.214 24.344 406.354 41.3279C375.601 52.7235 360.493 61.3799 337.349 73.7617C327.813 78.9117 318.491 81.8702 310.883 83.7329C311.954 66.4203 306.918 47.2449 287.953 46.2587C276.702 45.6012 258.808 46.9161 251.307 54.5863C256.986 37.4928 238.068 14.317 217.602 12.4542C158.578 7.08176 115.484 49.9573 99.9473 109.675C73.267 107.045 47.0448 137.397 69.7606 154.929C46.0805 152.299 2.07654 196.703 0.0406916 221.796C-0.280758 224.206 1.32649 225.96 4.00524 225.96C37.2217 227.822 70.5454 228.918 103.762 231C117.691 229.576 131.621 227.822 145.443 225.631C228.484 226.288 508 225.96 508 225.96Z"
                    fill="url(#06744177__paint0_linear_19033_10)"
                />
                <path
                    d="M508 225.96L459.071 72.666C459.071 72.666 452.214 24.344 406.354 41.3279C375.601 52.7235 360.493 61.3799 337.349 73.7617C327.813 78.9117 318.491 81.8702 310.883 83.7329C311.954 66.4203 306.918 47.2449 287.953 46.2587C276.702 45.6012 258.808 46.9161 251.307 54.5863C256.986 37.4928 238.068 14.317 217.602 12.4542C158.578 7.08176 115.484 49.9573 99.9473 109.675C73.267 107.045 47.0448 137.397 69.7606 154.929C46.0805 152.299 2.07654 196.703 0.0406916 221.796C-0.280758 224.206 1.32649 225.96 4.00524 225.96C37.2217 227.822 70.5454 228.918 103.762 231C117.691 229.576 131.621 227.822 145.443 225.631C228.484 226.288 508 225.96 508 225.96Z"
                    fill="#F2F6FB"
                />
            </g>
            <path
                d="M246.371 36.3185C249.057 32.4882 250.828 30.7035 253.886 27.0967"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M253.914 37.0417C255.965 35.4247 260.327 31.9676 262.377 30.3506"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M176.345 41.2637C176.312 49.0706 177.736 58.2427 182.672 62.7444C182.821 62.8988 182.932 63.0847 182.998 63.2881C183.064 63.4915 183.082 63.7071 183.052 63.9187C183.022 64.1302 182.944 64.3322 182.824 64.5094C182.704 64.6866 182.545 64.8344 182.359 64.9416C174.801 68.8985 168.823 75.2981 165.409 83.0865C165.31 83.3361 165.125 83.5424 164.887 83.6683C164.648 83.7941 164.373 83.8313 164.11 83.7732C163.846 83.715 163.612 83.5653 163.45 83.3509C163.288 83.1366 163.207 82.8717 163.224 82.6038C162.808 72.0709 159.653 63.5665 157.247 60.117C157.13 59.9466 157.053 59.7521 157.021 59.548C156.989 59.3438 157.004 59.1352 157.065 58.9376C157.125 58.7399 157.229 58.5583 157.369 58.4061C157.51 58.2539 157.683 58.135 157.876 58.0582C162.598 56.3913 169.369 50.6887 174.157 40.7159C174.259 40.4603 174.45 40.2502 174.696 40.1248C174.942 39.9993 175.225 39.9672 175.493 40.0342C175.761 40.1013 175.995 40.2631 176.152 40.4893C176.309 40.7155 176.377 40.9908 176.345 41.2637Z"
                fill="white"
            />
            <path
                d="M182.36 64.949C174.8 68.902 168.819 75.3001 165.404 83.0885C165.299 83.3572 165.094 83.5751 164.831 83.6962C164.568 83.8173 164.268 83.8323 163.994 83.738V83.7268C164.677 82.1255 169.078 63.9749 166.542 59.6976C170.67 57.626 174.525 44.1333 175.605 40.0801C175.836 40.1787 176.031 40.3454 176.163 40.5577C176.295 40.77 176.358 41.0176 176.344 41.2669C176.31 49.0713 177.732 58.2419 182.667 62.7545C182.816 62.9081 182.928 63.0934 182.994 63.2964C183.061 63.4993 183.08 63.7146 183.05 63.926C183.021 64.1374 182.943 64.3393 182.824 64.5165C182.704 64.6937 182.546 64.8416 182.36 64.949Z"
                fill="#D8E5FF"
            />
            <path
                d="M163.994 83.7258V83.737C163.764 83.6499 163.567 83.4948 163.428 83.2925C163.29 83.0903 163.218 82.8507 163.221 82.6061C162.811 72.0695 159.65 63.5708 157.25 60.122C157.108 59.9203 157.021 59.6846 157 59.439C160.137 60.1099 163.372 60.1972 166.541 59.6966C169.077 63.9739 164.676 82.1245 163.994 83.7258Z"
                fill="#ECF1FF"
            />
            <path
                d="M248.967 96.9284L212.635 52.4623C210.186 49.4644 205.941 48.6506 202.556 50.53L143.691 83.2168C143.691 83.2168 141.64 109.221 138.956 133.414C139.035 136.172 145.664 136.487 147.953 137.984C157.265 143.815 176.363 156.266 224.503 153.35C227.659 153.193 233.499 154.533 234.683 151.617C237.13 141.53 242.654 123.405 248.967 96.9284Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M207.55 80.2632L205.55 90.7632L183.05 144.763L180.05 142.263L207.55 80.2632Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M223.306 37.6168C219.158 44.4678 213.673 51.9947 212.481 53.8764C213.645 55.3294 213.803 56.5373 213.246 57.5934C212.393 59.2126 210.49 59.9264 208.858 59.3272C201.479 71.2009 179.747 93.5061 168.979 102.246C170.995 105.407 189.025 124.783 195.125 130.117C196.041 130.917 197.39 130.95 198.341 130.192C216.205 115.955 238.73 87.7825 241.274 83.664C241.428 83.4151 241.424 83.1142 241.278 82.8603C240.809 82.039 240.407 80.4998 240.941 79.4208C241.666 77.9553 243.423 77.3383 245.208 77.5019C245.506 77.5293 245.795 77.4117 245.96 77.1627C247.586 74.706 253.482 63.8044 256.348 57.8742C256.902 56.7287 256.508 55.3602 255.429 54.6849C249.103 50.7217 233.034 40.5156 226.722 36.7565C225.541 36.0519 224.018 36.4399 223.306 37.6168Z"
                fill="#FFCC00"
            />
            <path
                d="M226.653 77.6241C226.766 77.3629 226.721 77.0722 226.548 76.8468C226.005 76.1392 225.502 74.8359 225.746 73.6592C226.117 71.8676 227.932 71.0772 229.749 71.0202C230.052 71.0108 230.327 70.8534 230.457 70.5796C231.699 67.9737 235.648 56.947 237.615 50.8303C237.999 49.6356 237.434 48.3508 236.293 47.827C231.071 45.4252 219.59 40.0666 211.517 36.4011C208.342 42.3288 204.927 47.9645 204.078 49.5817C205.357 50.935 205.612 52.1261 205.144 53.224C204.425 54.9073 202.587 55.7736 200.912 55.3091C194.522 67.7438 174.679 91.7443 164.658 101.332C166.856 104.228 185.306 121.097 192.36 126.509C209.719 107.894 224.685 82.1352 226.653 77.6241Z"
                fill="#EBB409"
            />
            <path
                d="M198.108 33.7311C195.538 40.5846 192.32 47.7703 191.218 50.3819C191.092 50.6816 191.178 51.0132 191.404 51.2467C192.49 52.3625 192.777 53.5378 192.37 54.5321C191.82 55.8752 190.526 56.5729 188.862 56.8288C188.591 56.8707 188.36 57.0382 188.257 57.2926C183.195 69.7161 167.025 93.57 157.701 105.134C156.832 106.213 157.002 107.783 158.084 108.648C164.196 113.543 181.592 125.558 187.49 128.84C188.447 129.372 189.836 129.138 190.563 128.32C207.982 108.691 222.853 79.8649 224.672 75.0422C224.773 74.7757 224.713 74.4874 224.528 74.2709C223.951 73.5914 223.382 72.3158 223.565 71.1284C223.845 69.3205 225.618 68.4395 227.429 68.2896C227.731 68.2647 227.997 68.0936 228.113 67.814C229.221 65.1486 232.605 53.9359 234.258 47.7279C234.58 46.5156 233.951 45.2609 232.785 44.7953C225.873 42.0309 208.21 34.8418 201.317 32.2631C200.026 31.7783 198.592 32.4394 198.108 33.7311Z"
                fill="url(#06744177__paint1_linear_19033_10)"
            />
            <path
                d="M188.829 100.173C189.404 100.521 189.871 100.944 190.229 101.441C190.577 101.932 190.811 102.473 190.93 103.064C191.046 103.639 191.043 104.247 190.921 104.888C190.789 105.524 190.534 106.155 190.155 106.781C189.72 107.5 189.278 108.046 188.828 108.419C188.378 108.792 187.951 109.08 187.547 109.285L185.652 108.139C186.089 107.927 186.556 107.654 187.051 107.323C187.552 106.981 187.989 106.502 188.361 105.886C188.79 105.177 188.916 104.517 188.739 103.905C188.568 103.283 188.185 102.792 187.589 102.432C186.994 102.072 186.431 101.935 185.902 102.021C185.379 102.098 184.935 102.439 184.568 103.045C184.351 103.404 184.232 103.739 184.213 104.05C184.193 104.361 184.226 104.619 184.312 104.825L183.343 106.427L177.29 102.766L181.23 96.2509L183.017 97.3315L180.213 101.968L182.708 103.477C182.68 103.221 182.699 102.924 182.764 102.585C182.829 102.245 182.992 101.86 183.253 101.429C183.892 100.371 184.705 99.7339 185.692 99.5172C186.674 99.2839 187.72 99.5027 188.829 100.173ZM195.695 97.6197C195.354 98.1844 194.933 98.6378 194.431 98.9797C193.93 99.3216 193.351 99.5254 192.694 99.591C192.027 99.6504 191.275 99.5603 190.439 99.3207C189.608 99.0709 188.69 98.6416 187.683 98.0331C186.677 97.4245 185.875 96.8135 185.279 96.2002C184.678 95.5704 184.254 94.9495 184.007 94.3374C183.75 93.7191 183.662 93.1117 183.742 92.5151C183.812 91.9124 184.018 91.3287 184.359 90.7639C184.695 90.2094 185.11 89.7663 185.605 89.4347C186.096 89.0865 186.67 88.8797 187.327 88.814C187.983 88.7484 188.727 88.8406 189.558 89.0904C190.378 89.3341 191.286 89.7571 192.282 90.3595C193.288 90.968 194.095 91.5821 194.702 92.2016C195.309 92.8211 195.741 93.4401 195.998 94.0584C196.255 94.6767 196.354 95.2903 196.294 95.8992C196.23 96.4917 196.031 97.0652 195.695 97.6197ZM193.961 96.5918C194.123 96.3248 194.204 96.0514 194.205 95.7715C194.195 95.4854 194.077 95.1825 193.85 94.8627C193.623 94.5429 193.276 94.2001 192.81 93.8342C192.35 93.458 191.746 93.0433 190.996 92.5899C190.257 92.1428 189.614 91.8031 189.067 91.5707C188.527 91.328 188.062 91.1802 187.674 91.1274C187.291 91.0643 186.971 91.0951 186.713 91.2198C186.462 91.3341 186.252 91.5299 186.084 91.8072C185.917 92.0844 185.838 92.3661 185.847 92.6522C185.856 92.9383 185.971 93.2463 186.192 93.5764C186.42 93.8962 186.763 94.2442 187.223 94.6203C187.689 94.9862 188.291 95.3927 189.031 95.8398C189.78 96.2932 190.425 96.6412 190.966 96.8838C191.512 97.1163 191.98 97.2589 192.369 97.3117C192.764 97.3542 193.087 97.3183 193.338 97.2039C193.586 97.0731 193.793 96.8691 193.961 96.5918ZM200.817 89.1514C200.475 89.7162 200.054 90.1695 199.553 90.5114C199.051 90.8534 198.472 91.0571 197.816 91.1227C197.149 91.1821 196.397 91.092 195.56 90.8524C194.729 90.6026 193.811 90.1734 192.805 89.5648C191.798 88.9562 190.997 88.3453 190.4 87.7319C189.799 87.1022 189.376 86.4812 189.129 85.8691C188.872 85.2508 188.783 84.6434 188.863 84.0469C188.933 83.4441 189.139 82.8604 189.481 82.2956C189.816 81.7411 190.231 81.2981 190.726 80.9664C191.217 80.6183 191.791 80.4114 192.448 80.3458C193.105 80.2802 193.848 80.3723 194.679 80.6222C195.499 80.8658 196.407 81.2888 197.403 81.8912C198.41 82.4998 199.216 83.1138 199.823 83.7333C200.43 84.3529 200.862 84.9718 201.12 85.5901C201.377 86.2084 201.475 86.822 201.416 87.431C201.352 88.0234 201.152 88.5969 200.817 89.1514ZM199.082 88.1235C199.244 87.8566 199.325 87.5831 199.326 87.3032C199.317 87.0172 199.199 86.7142 198.971 86.3944C198.744 86.0746 198.397 85.7318 197.931 85.3659C197.472 84.9897 196.867 84.575 196.118 84.1217C195.378 83.6745 194.735 83.3348 194.189 83.1024C193.648 82.8597 193.184 82.712 192.795 82.6591C192.412 82.5961 192.092 82.6268 191.835 82.7515C191.583 82.8658 191.373 83.0616 191.206 83.3389C191.038 83.6161 190.959 83.8978 190.968 84.1839C190.978 84.47 191.093 84.7781 191.314 85.1081C191.541 85.4279 191.885 85.7759 192.344 86.152C192.81 86.5179 193.413 86.9244 194.152 87.3716C194.902 87.8249 195.547 88.1729 196.087 88.4156C196.634 88.648 197.101 88.7906 197.49 88.8434C197.885 88.8859 198.208 88.85 198.46 88.7357C198.707 88.6048 198.915 88.4008 199.082 88.1235ZM200.807 75.1857L195.801 72.1583L197.599 69.1857C197.94 68.6209 198.317 68.1479 198.73 67.7665C199.139 67.3687 199.576 67.0862 200.042 66.9191C200.508 66.752 201.002 66.7002 201.524 66.7638C202.047 66.8273 202.591 67.0299 203.155 67.3714C203.73 67.7192 204.159 68.1117 204.442 68.549C204.72 68.9698 204.885 69.4273 204.937 69.9214C204.989 70.4155 204.928 70.9328 204.756 71.4735C204.583 72.0141 204.326 72.5668 203.984 73.1316L203.556 73.8401L204.48 74.399L206.296 71.3955L207.713 72.2525L205.897 75.256L208.176 76.6346L206.844 78.8371L204.565 77.4585L203.903 78.5521L202.486 77.6951L203.148 76.6015L202.224 76.0426L201.562 77.1362L200.145 76.2792L200.807 75.1857ZM198.843 70.9897L202.139 72.9831L202.586 72.2438C203.244 71.1554 202.998 70.2634 201.848 69.5679C201.273 69.2201 200.79 69.1032 200.398 69.2171C200.013 69.3207 199.65 69.6549 199.308 70.2196L198.843 70.9897Z"
                fill="white"
            />
            <path
                d="M196.969 56.011C197.475 56.2859 197.66 56.9192 197.385 57.4247C197.261 57.6513 197.066 57.8136 196.842 57.8992C196.566 58.0049 196.248 57.9937 195.969 57.8417C195.469 57.5684 195.244 56.9253 195.51 56.4215C195.776 55.917 196.361 55.701 196.87 55.9597L196.395 56.8878L196.884 55.967C196.892 55.9709 196.96 56.0064 196.969 56.011ZM206.143 60.0119C205.615 59.7831 205 60.0239 204.77 60.5537C204.541 61.0817 204.783 61.6958 205.312 61.9243L205.42 61.9697C205.673 62.07 205.942 62.0644 206.178 61.974C206.441 61.8734 206.663 61.6669 206.775 61.3856C206.987 60.85 206.727 60.2446 206.19 60.0322L206.143 60.0119ZM201.034 58.9897L201.45 58.0333C200.922 57.8045 200.307 58.0453 200.077 58.5751C199.848 59.1031 200.09 59.7172 200.619 59.9457C200.626 59.9494 200.709 59.9845 200.716 59.987C200.972 60.0918 201.245 60.0873 201.484 59.9957C201.744 59.8963 201.964 59.6933 202.077 59.4162C202.295 58.8835 202.04 58.2752 201.506 58.0575L201.034 58.9897ZM210.829 62.0066C210.301 61.7768 209.719 62.0335 209.491 62.563C209.261 63.091 209.536 63.7184 210.065 63.948C210.328 64.0651 210.614 64.0645 210.863 63.969C211.113 63.8735 211.326 63.683 211.443 63.4202C211.678 62.8946 211.442 62.2789 210.916 62.0439L210.829 62.0066ZM220.223 66.3628C220.214 66.3581 220.13 66.3151 220.12 66.31C219.61 66.0583 219.027 66.2779 218.765 66.7851C218.504 67.2915 218.734 67.9315 219.236 68.2008C219.515 68.3486 219.83 68.3591 220.103 68.2547C220.329 68.1681 220.525 68.0026 220.649 67.7733C220.922 67.2654 220.731 66.6342 220.223 66.3628ZM215.493 64.0831C214.972 63.8513 214.4 64.0974 214.159 64.6134C213.919 65.1295 214.176 65.7596 214.689 66.0075C214.959 66.138 215.257 66.1417 215.517 66.0423C215.756 65.9506 215.963 65.7715 216.083 65.5228C216.334 65.0037 216.117 64.3805 215.599 64.1301C215.588 64.1261 215.502 64.0867 215.493 64.0831Z"
                fill="#891712"
            />
            <path
                d="M248.967 96.9288L193.567 118.127C191.515 118.915 189.226 118.599 187.49 117.26L143.691 83.2173C143.691 83.2173 140.061 107.646 138.956 133.414C139.035 136.172 140.534 138.694 142.823 140.191C156.239 147.047 187.49 156.739 227.659 156.739C230.816 156.582 233.578 154.612 234.762 151.696C238.313 141.531 243.048 125.376 248.967 96.9288Z"
                fill="#D4E0ED"
            />
            <path
                d="M239.072 122.369C239.041 129.46 240.335 137.792 244.819 141.881C244.954 142.021 245.055 142.19 245.115 142.375C245.175 142.559 245.191 142.755 245.164 142.947C245.137 143.14 245.066 143.323 244.957 143.484C244.848 143.645 244.703 143.779 244.535 143.877C237.669 147.471 232.239 153.284 229.138 160.359C229.048 160.585 228.88 160.773 228.663 160.887C228.447 161.001 228.197 161.035 227.957 160.982C227.718 160.929 227.506 160.793 227.358 160.599C227.211 160.404 227.138 160.163 227.153 159.92C226.775 150.352 223.91 142.627 221.724 139.494C221.618 139.339 221.547 139.163 221.519 138.977C221.49 138.792 221.503 138.602 221.558 138.423C221.613 138.243 221.708 138.078 221.835 137.94C221.963 137.802 222.12 137.694 222.295 137.624C226.584 136.11 232.735 130.93 237.084 121.871C237.176 121.639 237.35 121.448 237.574 121.334C237.797 121.22 238.054 121.191 238.298 121.252C238.541 121.313 238.754 121.46 238.896 121.665C239.039 121.871 239.101 122.121 239.072 122.369Z"
                fill="white"
            />
            <path
                d="M244.535 143.883C237.667 147.473 232.234 153.285 229.132 160.36C229.037 160.604 228.851 160.802 228.612 160.912C228.373 161.022 228.1 161.036 227.852 160.95V160.94C228.471 159.485 232.469 142.998 230.165 139.113C233.915 137.231 237.417 124.975 238.399 121.293C238.608 121.383 238.785 121.534 238.905 121.727C239.025 121.92 239.083 122.145 239.07 122.371C239.039 129.46 240.33 137.79 244.814 141.889C244.949 142.029 245.05 142.197 245.111 142.382C245.171 142.566 245.188 142.762 245.161 142.954C245.134 143.146 245.064 143.329 244.955 143.49C244.847 143.651 244.703 143.785 244.535 143.883Z"
                fill="#D8E5FF"
            />
            <path
                d="M227.852 160.94V160.95C227.643 160.871 227.464 160.73 227.338 160.546C227.213 160.362 227.147 160.145 227.15 159.922C226.778 150.351 223.906 142.632 221.726 139.499C221.597 139.316 221.518 139.102 221.499 138.878C224.349 139.488 227.287 139.567 230.166 139.112C232.47 142.998 228.472 159.485 227.852 160.94Z"
                fill="#ECF1FF"
            />
            <path
                d="M126.133 51.8481C126.013 51.8484 125.892 51.8336 125.775 51.8041C125.594 51.7592 125.423 51.679 125.273 51.5682C125.122 51.4574 124.996 51.3182 124.9 51.1585C124.804 50.9988 124.741 50.8218 124.714 50.6378C124.687 50.4537 124.697 50.2661 124.743 50.086L125.797 46.0586C125.897 45.6959 126.136 45.3864 126.462 45.1966C126.788 45.0068 127.176 44.9517 127.543 45.0432C127.724 45.0881 127.895 45.1682 128.045 45.279C128.196 45.3898 128.322 45.5291 128.418 45.6888C128.514 45.8485 128.577 46.0254 128.604 46.2095C128.631 46.3936 128.621 46.5811 128.575 46.7613L127.521 50.7887C127.44 51.0929 127.26 51.3619 127.009 51.5536C126.758 51.7452 126.45 51.8488 126.133 51.8481Z"
                fill="#1CB5F9"
            />
            <path
                d="M123.193 63.0882C123.072 63.0885 122.952 63.0737 122.835 63.0442C122.653 62.9993 122.482 62.9191 122.332 62.8083C122.182 62.6975 122.055 62.5583 121.959 62.3986C121.863 62.2389 121.8 62.0619 121.773 61.8779C121.747 61.6938 121.757 61.5062 121.803 61.3261L122.857 57.2987C122.956 56.9358 123.195 56.6261 123.521 56.4362C123.847 56.2463 124.236 56.1914 124.602 56.2832C124.784 56.3281 124.955 56.4083 125.105 56.5191C125.255 56.6299 125.382 56.7692 125.478 56.9288C125.574 57.0885 125.637 57.2655 125.664 57.4496C125.691 57.6337 125.68 57.8212 125.634 58.0014L124.58 62.0287C124.499 62.333 124.319 62.6019 124.068 62.7936C123.817 62.9853 123.509 63.0889 123.193 63.0882Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.945 57.4213C132.824 57.4216 132.703 57.4068 132.586 57.3772L128.495 56.3397C128.313 56.2948 128.143 56.2146 127.992 56.1038C127.842 55.993 127.715 55.8538 127.62 55.6941C127.524 55.5344 127.46 55.3574 127.434 55.1734C127.407 54.9893 127.417 54.8018 127.463 54.6216C127.562 54.2582 127.8 53.9481 128.127 53.7581C128.453 53.568 128.842 53.5135 129.209 53.6061L133.3 54.6436C133.637 54.7269 133.932 54.9303 134.128 55.2153C134.324 55.5003 134.408 55.8471 134.365 56.1897C134.321 56.5324 134.152 56.8471 133.89 57.0741C133.628 57.3011 133.292 57.4247 132.945 57.4213L132.945 57.4213Z"
                fill="#1CB5F9"
            />
            <path
                d="M121.526 54.5252C121.405 54.5256 121.285 54.5108 121.167 54.4812L117.076 53.4451C116.894 53.4002 116.724 53.3201 116.573 53.2094C116.423 53.0986 116.296 52.9593 116.2 52.7996C116.105 52.6399 116.041 52.4629 116.015 52.2788C115.988 52.0947 115.998 51.9071 116.044 51.7269C116.143 51.3637 116.381 51.0536 116.708 50.8636C117.034 50.6736 117.423 50.619 117.79 50.7115L121.881 51.7476C122.218 51.8308 122.513 52.0343 122.709 52.3193C122.905 52.6043 122.99 52.951 122.946 53.2937C122.902 53.6363 122.733 53.951 122.471 54.178C122.21 54.4051 121.873 54.5286 121.526 54.5252L121.526 54.5252Z"
                fill="#1CB5F9"
            />
            <path
                d="M279.133 149.848C279.013 149.848 278.892 149.834 278.775 149.804C278.594 149.759 278.423 149.679 278.273 149.568C278.122 149.457 277.996 149.318 277.9 149.158C277.804 148.999 277.741 148.822 277.714 148.638C277.687 148.454 277.697 148.266 277.743 148.086L278.797 144.059C278.897 143.696 279.136 143.386 279.462 143.197C279.788 143.007 280.176 142.952 280.543 143.043C280.724 143.088 280.895 143.168 281.045 143.279C281.196 143.39 281.322 143.529 281.418 143.689C281.514 143.848 281.577 144.025 281.604 144.21C281.631 144.394 281.621 144.581 281.575 144.761L280.521 148.789C280.44 149.093 280.26 149.362 280.009 149.554C279.758 149.745 279.45 149.849 279.133 149.848Z"
                fill="#1CB5F9"
            />
            <path
                d="M276.193 161.088C276.072 161.089 275.952 161.074 275.835 161.044C275.653 160.999 275.482 160.919 275.332 160.808C275.182 160.698 275.055 160.558 274.959 160.399C274.863 160.239 274.8 160.062 274.773 159.878C274.747 159.694 274.757 159.506 274.803 159.326L275.857 155.299C275.956 154.936 276.195 154.626 276.521 154.436C276.847 154.246 277.236 154.191 277.602 154.283C277.784 154.328 277.955 154.408 278.105 154.519C278.255 154.63 278.382 154.769 278.478 154.929C278.574 155.089 278.637 155.266 278.664 155.45C278.691 155.634 278.68 155.821 278.634 156.001L277.58 160.029C277.499 160.333 277.319 160.602 277.068 160.794C276.817 160.985 276.509 161.089 276.193 161.088Z"
                fill="#1CB5F9"
            />
            <path
                d="M285.945 155.421C285.824 155.422 285.703 155.407 285.586 155.377L281.495 154.34C281.313 154.295 281.143 154.215 280.992 154.104C280.842 153.993 280.715 153.854 280.62 153.694C280.524 153.534 280.46 153.357 280.434 153.173C280.407 152.989 280.417 152.802 280.463 152.622C280.562 152.258 280.8 151.948 281.127 151.758C281.453 151.568 281.842 151.513 282.209 151.606L286.3 152.644C286.637 152.727 286.932 152.93 287.128 153.215C287.324 153.5 287.408 153.847 287.365 154.19C287.321 154.532 287.152 154.847 286.89 155.074C286.628 155.301 286.292 155.425 285.945 155.421L285.945 155.421Z"
                fill="#1CB5F9"
            />
            <path
                d="M274.526 152.525C274.405 152.526 274.285 152.511 274.167 152.481L270.076 151.445C269.894 151.4 269.724 151.32 269.573 151.209C269.423 151.099 269.296 150.959 269.2 150.8C269.105 150.64 269.041 150.463 269.015 150.279C268.988 150.095 268.998 149.907 269.044 149.727C269.143 149.364 269.381 149.054 269.708 148.864C270.034 148.674 270.423 148.619 270.79 148.711L274.881 149.748C275.218 149.831 275.513 150.034 275.709 150.319C275.905 150.604 275.99 150.951 275.946 151.294C275.902 151.636 275.733 151.951 275.471 152.178C275.21 152.405 274.873 152.529 274.526 152.525L274.526 152.525Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="06744177__paint0_linear_19033_10"
                x1={144.412}
                y1={24.1047}
                x2={190.955}
                y2={238.576}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.206374} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="06744177__paint1_linear_19033_10"
                x1={187.945}
                y1={127.506}
                x2={204.998}
                y2={33.944}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="06744177__clip0_19033_10">
                <rect width={307} height={180} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default Promo500M;
