import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PromoSaleXs = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 145 102"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#2a571356__clip0_19033_12)">
            <path
                opacity={0.5}
                d="M233.483 111.094L211.022 36.5149C211.022 36.5149 207.874 13.0055 186.821 21.2684C172.704 26.8126 165.769 31.024 155.144 37.048C150.766 39.5535 146.487 40.9929 142.995 41.8991C143.486 33.4763 141.175 24.1471 132.468 23.6674C127.304 23.3475 119.089 23.9872 115.646 27.7189C118.253 19.4026 109.568 8.12726 100.173 7.221C73.0777 4.6072 53.2952 25.4668 46.1629 54.5203C33.9151 53.2409 21.8776 68.0076 32.3055 76.537C21.4349 75.2576 1.2345 96.8609 0.29993 109.069C0.152366 110.242 0.890187 111.095 2.11989 111.095C17.3682 112.001 32.6657 112.534 47.914 113.547C54.3085 112.854 60.7029 112.001 67.0482 110.935C105.169 111.254 233.483 111.094 233.483 111.094Z"
                fill="url(#2a571356__paint0_linear_19033_12)"
            />
            <path
                d="M84.3451 29.7218C84.3261 34.1807 85.1395 39.4194 87.959 41.9906C88.0438 42.0788 88.1074 42.185 88.1449 42.3011C88.1825 42.4173 88.193 42.5405 88.1758 42.6613C88.1586 42.7821 88.114 42.8975 88.0455 42.9987C87.9769 43.0999 87.8862 43.1843 87.7801 43.2456C83.4632 45.5055 80.0487 49.1607 78.0991 53.6091C78.0425 53.7517 77.9367 53.8695 77.8006 53.9414C77.6645 54.0133 77.5071 54.0345 77.3567 54.0013C77.2063 53.9681 77.0727 53.8826 76.98 53.7602C76.8872 53.6377 76.8415 53.4864 76.8508 53.3334C76.6131 47.3175 74.8115 42.4602 73.4374 40.4899C73.3703 40.3926 73.3261 40.2815 73.3081 40.1649C73.29 40.0483 73.2985 39.9292 73.3329 39.8163C73.3674 39.7034 73.4269 39.5997 73.5071 39.5127C73.5872 39.4258 73.686 39.3579 73.7961 39.3141C76.4934 38.362 80.3607 35.1049 83.0955 29.4089C83.1534 29.2629 83.2628 29.1429 83.4032 29.0713C83.5436 28.9996 83.7054 28.9812 83.8584 29.0196C84.0114 29.0579 84.1451 29.1502 84.2347 29.2795C84.3243 29.4087 84.3635 29.5659 84.3451 29.7218Z"
                fill="white"
            />
            <path
                d="M87.781 43.2495C83.4626 45.5072 80.0467 49.1616 78.0964 53.6099C78.0365 53.7634 77.9192 53.8878 77.7689 53.957C77.6187 54.0262 77.4474 54.0348 77.291 53.9809V53.9745C77.6808 53.0599 80.1944 42.6931 78.746 40.2501C81.1038 39.0669 83.3057 31.3604 83.9228 29.0454C84.0545 29.1017 84.1657 29.1969 84.2412 29.3182C84.3167 29.4394 84.3529 29.5809 84.345 29.7233C84.3255 34.1808 85.1374 39.4187 87.9564 41.996C88.0414 42.0838 88.1052 42.1896 88.1431 42.3055C88.181 42.4215 88.1919 42.5444 88.175 42.6651C88.1581 42.7859 88.1139 42.9012 88.0456 43.0024C87.9774 43.1036 87.8869 43.1881 87.781 43.2495Z"
                fill="#D8E5FF"
            />
            <path
                d="M77.2905 53.9741V53.9805C77.1593 53.9308 77.0465 53.8422 76.9676 53.7266C76.8886 53.6111 76.8471 53.4743 76.8488 53.3346C76.615 47.3165 74.8093 42.4625 73.4388 40.4926C73.3573 40.3775 73.308 40.2429 73.2959 40.1025C75.0877 40.4857 76.9354 40.5356 78.7455 40.2497C80.1939 42.6927 77.6803 53.0595 77.2905 53.9741Z"
                fill="#ECF1FF"
            />
            <path
                d="M124.758 59.8859L107.403 38.6456C104.953 35.6477 100.709 34.8339 97.3241 36.7133L68.7337 52.5891C68.7337 52.5891 67.6419 66.4277 66.2139 79.302C66.2559 80.7698 69.7838 80.9374 71.0017 81.7341C75.9573 84.8374 86.1206 91.4632 111.739 89.9115C113.419 89.8277 116.526 90.5407 117.156 88.9891C118.458 83.6212 121.398 73.9761 124.758 59.8859Z"
                fill="#C6D4E3"
            />
            <g
                style={{
                    mixBlendMode: 'multiply',
                }}
            >
                <path
                    d="M102.717 51.0173L101.652 56.6051L89.6785 85.3419L88.082 84.0115L102.717 51.0173Z"
                    fill="#1C508B"
                    fillOpacity={0.1}
                />
            </g>
            <path
                d="M111.1 28.3222C108.892 31.9681 105.973 35.9736 105.339 36.975C105.959 37.7482 106.043 38.391 105.746 38.9531C105.292 39.8147 104.28 40.1945 103.411 39.8757C99.4842 46.1944 87.9194 58.0645 82.1889 62.7156C83.2618 64.3975 92.8566 74.7089 96.1031 77.5474C96.5903 77.9734 97.3084 77.9908 97.8147 77.5875C107.321 70.0109 119.308 55.0186 120.662 52.8268C120.744 52.6944 120.742 52.5343 120.664 52.3992C120.414 51.9621 120.2 51.143 120.485 50.5688C120.87 49.7889 121.806 49.4605 122.755 49.5476C122.914 49.5622 123.068 49.4996 123.155 49.3671C124.021 48.0598 127.159 42.2583 128.684 39.1024C128.979 38.4928 128.769 37.7646 128.195 37.4052C124.828 35.2961 116.277 29.8648 112.918 27.8644C112.289 27.4894 111.479 27.6959 111.1 28.3222Z"
                fill="#FFCC00"
            />
            <path
                d="M112.881 49.6125C112.941 49.4736 112.918 49.3189 112.825 49.1989C112.536 48.8223 112.269 48.1288 112.398 47.5026C112.596 46.5492 113.562 46.1285 114.529 46.0982C114.69 46.0932 114.836 46.0095 114.906 45.8638C115.567 44.477 117.668 38.609 118.715 35.3539C118.919 34.7181 118.618 34.0344 118.011 33.7556C115.233 32.4775 109.122 29.6258 104.827 27.6752C103.137 30.8297 101.319 33.8288 100.868 34.6894C101.548 35.4096 101.684 36.0435 101.435 36.6277C101.052 37.5235 100.074 37.9845 99.1829 37.7373C95.7824 44.3547 85.2224 57.1268 79.8896 62.2291C81.0595 63.7702 90.878 72.7474 94.6319 75.6271C103.869 65.7209 111.834 52.0132 112.881 49.6125Z"
                fill="#EBB409"
            />
            <path
                d="M97.6906 26.2543C96.3229 29.9015 94.6103 33.7255 94.0239 35.1153C93.9567 35.2748 94.0023 35.4513 94.1227 35.5755C94.7006 36.1693 94.8535 36.7948 94.6368 37.3239C94.3444 38.0386 93.6556 38.4099 92.7701 38.5461C92.6259 38.5684 92.5028 38.6575 92.4478 38.7929C89.7544 45.4042 81.1492 58.0984 76.1874 64.2521C75.7246 64.8264 75.8153 65.662 76.3909 66.1225C79.6436 68.7274 88.9014 75.121 92.04 76.8677C92.5493 77.1511 93.2885 77.0267 93.6753 76.5909C102.945 66.1453 110.859 50.8051 111.827 48.2386C111.88 48.0968 111.848 47.9433 111.75 47.8281C111.443 47.4665 111.14 46.7877 111.238 46.1558C111.386 45.1937 112.33 44.7249 113.294 44.6451C113.454 44.6319 113.596 44.5408 113.658 44.392C114.248 42.9736 116.048 37.0066 116.928 33.7029C117.1 33.0578 116.765 32.3901 116.144 32.1423C112.466 30.6712 103.066 26.8454 99.3981 25.4731C98.7111 25.2151 97.9481 25.5669 97.6906 26.2543Z"
                fill="url(#2a571356__paint1_linear_19033_12)"
            />
            <path
                d="M94.6362 63.489C94.4813 63.7381 94.3234 63.954 94.1627 64.1366C94.0055 64.3136 93.8504 64.4684 93.6973 64.6009C93.5478 64.7277 93.4032 64.834 93.2635 64.9198C93.1216 64.9965 92.9913 65.0607 92.8727 65.1126L91.8537 64.4788C91.978 64.4305 92.1164 64.3595 92.2688 64.2659C92.4191 64.1631 92.5725 64.0426 92.7291 63.9045C92.8857 63.7663 93.0408 63.6116 93.1945 63.4402C93.3481 63.2689 93.4866 63.0841 93.6098 62.886C93.8457 62.5067 93.9831 62.1721 94.022 61.8823C94.061 61.5925 93.9446 61.3631 93.6728 61.1941C93.5257 61.1026 93.3846 61.058 93.2496 61.0604C93.1146 61.0628 92.9808 61.1013 92.8481 61.1758C92.7154 61.2503 92.5754 61.3555 92.428 61.4915C92.2841 61.6219 92.1297 61.7692 91.9647 61.9335C91.7764 62.1226 91.5705 62.3086 91.3469 62.4914C91.1268 62.6685 90.8925 62.8054 90.644 62.9021C90.3954 62.9988 90.1295 63.0414 89.8461 63.03C89.5605 63.0094 89.2536 62.8971 88.9252 62.6928C88.6365 62.5133 88.417 62.2982 88.2666 62.0477C88.1106 61.7937 88.0241 61.5161 88.0072 61.2151C87.9903 60.9141 88.0366 60.5935 88.146 60.2534C88.2534 59.9041 88.4215 59.5454 88.6503 59.1774C88.9214 58.7415 89.1804 58.4198 89.4273 58.2122C89.672 57.9954 89.8763 57.8437 90.04 57.7571L91.059 58.3909C90.8331 58.5016 90.6035 58.6689 90.3701 58.8927C90.1367 59.1166 89.9108 59.404 89.6925 59.7549C89.4285 60.1795 89.2925 60.5307 89.2846 60.8084C89.2711 61.0826 89.3748 61.2884 89.5955 61.4257C89.7314 61.5102 89.864 61.5495 89.9933 61.5436C90.1205 61.5284 90.2458 61.4847 90.3693 61.4123C90.4928 61.34 90.6184 61.2454 90.746 61.1285C90.8715 61.0024 91.0052 60.8696 91.1469 60.7301C91.3514 60.5275 91.5644 60.3303 91.7858 60.1383C92.0108 59.9406 92.2511 59.7878 92.5067 59.6798C92.7622 59.5718 93.0374 59.5271 93.3321 59.5455C93.6247 59.5547 93.9436 59.6667 94.289 59.8815C94.657 60.1104 94.9158 60.3695 95.0656 60.6589C95.2188 60.9426 95.2986 61.2435 95.305 61.5615C95.3057 61.8759 95.2428 62.198 95.1163 62.5276C94.9899 62.8571 94.8298 63.1776 94.6362 63.489ZM98.1411 57.6639C98.0457 57.6281 97.9247 57.5764 97.7783 57.5089C97.6297 57.4322 97.501 57.3678 97.392 57.3158C97.4601 57.4209 97.5165 57.5385 97.5613 57.6684C97.6097 57.7927 97.64 57.9332 97.6524 58.0901C97.6591 58.2434 97.6393 58.4078 97.593 58.5831C97.5503 58.7528 97.4691 58.9339 97.3494 59.1264C97.2332 59.3132 97.0968 59.4757 96.9402 59.6138C96.7872 59.7463 96.6164 59.8442 96.4279 59.9075C96.2428 59.9652 96.0482 59.9815 95.8439 59.9565C95.6396 59.9315 95.4299 59.8521 95.2148 59.7183C94.7449 59.4261 94.497 59.0168 94.4711 58.4904C94.4452 57.964 94.6435 57.3611 95.066 56.6818L95.404 56.1383L95.2087 56.0168C94.937 55.8478 94.709 55.8042 94.5247 55.8858C94.3383 55.9583 94.1501 56.1474 93.9599 56.4531C93.7698 56.7588 93.6352 57.0637 93.556 57.3677C93.4768 57.6718 93.4255 57.95 93.402 58.2023L92.4679 57.6214C92.4914 57.369 92.5568 57.0682 92.6641 56.7189C92.7715 56.3696 92.9361 56.0166 93.1579 55.6599C93.517 55.0825 93.9186 54.7081 94.3627 54.5368C94.8104 54.3599 95.3003 54.4369 95.8324 54.7678L98.0827 56.1673C98.1337 56.199 98.1931 56.236 98.261 56.2782C98.3268 56.3113 98.3937 56.349 98.4616 56.3912C98.5331 56.4278 98.6017 56.4626 98.6675 56.4957C98.7276 56.5253 98.7793 56.5495 98.8224 56.5685L98.1411 57.6639ZM96.7305 58.2469C96.8502 58.0544 96.9074 57.8741 96.9021 57.7059C96.8911 57.5342 96.853 57.3809 96.7877 57.2461C96.7223 57.1113 96.6458 57.0009 96.558 56.9148C96.468 56.8196 96.4004 56.758 96.3551 56.7298L96.0918 56.5661L95.7803 57.0671C95.562 57.4181 95.4612 57.7126 95.478 57.9507C95.4926 58.1797 95.599 58.3557 95.7972 58.479C95.9783 58.5916 96.1515 58.6287 96.3168 58.5902C96.4799 58.5425 96.6178 58.428 96.7305 58.2469ZM94.0485 50.6681L100.137 54.4547L99.4082 55.6266L93.3197 51.84L94.0485 50.6681ZM102.868 49.4197C102.865 49.5123 102.859 49.618 102.848 49.7367C102.834 49.8463 102.809 49.9756 102.771 50.1248C102.731 50.2648 102.671 50.424 102.592 50.6022C102.522 50.7783 102.418 50.9768 102.28 51.1976C101.745 52.0581 101.148 52.57 100.489 52.7332C99.8304 52.8965 99.1386 52.7528 98.4139 52.3022C98.0573 52.0804 97.7709 51.8277 97.5547 51.5441C97.3421 51.2548 97.2011 50.9512 97.1319 50.6334C97.057 50.312 97.0531 49.9838 97.1202 49.6487C97.1851 49.3044 97.3215 48.9652 97.5292 48.6312C97.7404 48.2916 97.9872 48.0211 98.2694 47.8198C98.5459 47.6149 98.8464 47.4916 99.1706 47.4499C99.4984 47.4026 99.8476 47.447 100.218 47.5833C100.589 47.7196 100.968 47.9555 101.356 48.291L99.4971 51.2801C99.8706 51.4495 100.208 51.487 100.511 51.3923C100.811 51.2885 101.102 51.0101 101.383 50.5572C101.609 50.1949 101.752 49.8759 101.814 49.6001C101.879 49.3187 101.922 49.0667 101.942 48.8441L102.868 49.4197ZM98.4144 49.1582C98.2524 49.4186 98.1961 49.6859 98.2455 49.96C98.2949 50.234 98.4502 50.4955 98.7115 50.7444L99.8523 48.9102C99.5444 48.7109 99.2701 48.6344 99.0292 48.6809C98.7883 48.7274 98.5834 48.8865 98.4144 49.1582Z"
                fill="white"
            />
            <path
                d="M97.7392 37.8764C98.0089 38.0218 98.1086 38.3585 97.9628 38.6279C97.8976 38.7488 97.7939 38.8354 97.675 38.8814C97.5283 38.9381 97.3591 38.9327 97.2103 38.8523C96.9434 38.7078 96.8225 38.3659 96.9635 38.0974C97.1043 37.8284 97.4153 37.7125 97.6863 37.8492L97.4352 38.344L97.6936 37.8531C97.6981 37.8551 97.7345 37.8739 97.7392 37.8764ZM102.628 39.9895C102.347 39.8687 102.02 39.9979 101.899 40.2802C101.777 40.5616 101.907 40.888 102.189 41.0087L102.247 41.0326C102.382 41.0856 102.525 41.0821 102.65 41.0336C102.79 40.9796 102.908 40.8693 102.967 40.7194C103.079 40.434 102.939 40.1123 102.653 40.0002L102.628 39.9895ZM99.9077 39.4544L100.127 38.9448C99.8458 38.8239 99.519 38.9531 99.3977 39.2355C99.2765 39.5168 99.4065 39.8432 99.6885 39.9639C99.6921 39.9658 99.7364 39.9844 99.7403 39.9857C99.8765 40.041 100.022 40.0382 100.149 39.989C100.287 39.9356 100.403 39.8273 100.463 39.6796C100.579 39.3957 100.442 39.0725 100.157 38.9575L99.9077 39.4544ZM105.125 41.0429C104.844 40.9215 104.535 41.0591 104.414 41.3413C104.293 41.6226 104.44 41.9561 104.722 42.0773C104.862 42.1392 105.014 42.1384 105.147 42.0871C105.28 42.0358 105.393 41.9341 105.455 41.794C105.579 41.5139 105.452 41.1867 105.172 41.0626L105.125 41.0429ZM110.132 43.3447C110.127 43.3422 110.083 43.3195 110.077 43.3168C109.805 43.1837 109.495 43.3016 109.357 43.5719C109.219 43.8419 109.343 44.1821 109.61 44.3245C109.759 44.4027 109.926 44.4077 110.071 44.3517C110.191 44.3052 110.296 44.2168 110.361 44.0946C110.505 43.8238 110.403 43.4882 110.132 43.3447ZM107.611 42.1398C107.333 42.0173 107.029 42.1493 106.902 42.4243C106.775 42.6993 106.913 43.0342 107.186 43.1653C107.33 43.2342 107.489 43.2356 107.627 43.1823C107.754 43.1331 107.864 43.0374 107.927 42.9049C108.06 42.6282 107.944 42.2969 107.667 42.1646C107.662 42.1625 107.616 42.1416 107.611 42.1398Z"
                fill="#891712"
            />
            <path
                d="M124.758 59.8861L95.2758 71.1668C94.1838 71.5861 92.9659 71.4184 92.042 70.7055L68.7337 52.5894C68.7337 52.5894 66.802 65.5894 66.2139 79.3023C66.2559 80.77 67.0538 82.1119 68.2717 82.9087C75.4114 86.5571 92.042 91.7152 113.418 91.7152C115.098 91.6313 116.568 90.5829 117.198 89.0313C119.088 83.6216 121.608 75.0248 124.758 59.8861Z"
                fill="#D4E0ED"
            />
            <path
                d="M120.173 76.0453C120.155 80.0956 120.894 84.8542 123.455 87.1897C123.532 87.2698 123.59 87.3663 123.624 87.4718C123.658 87.5773 123.668 87.6892 123.652 87.799C123.637 87.9087 123.596 88.0135 123.534 88.1054C123.472 88.1974 123.389 88.274 123.293 88.3297C119.371 90.3825 116.27 93.7028 114.499 97.7435C114.448 97.873 114.352 97.98 114.228 98.0453C114.104 98.1106 113.961 98.1299 113.825 98.0997C113.688 98.0696 113.567 97.9919 113.482 97.8807C113.398 97.7695 113.357 97.632 113.365 97.493C113.149 92.0284 111.513 87.6163 110.265 85.8266C110.204 85.7382 110.163 85.6373 110.147 85.5314C110.131 85.4255 110.138 85.3172 110.17 85.2147C110.201 85.1122 110.255 85.0179 110.328 84.939C110.401 84.86 110.49 84.7983 110.59 84.7585C113.04 83.8937 116.553 80.9351 119.037 75.761C119.09 75.6285 119.19 75.5194 119.317 75.4544C119.445 75.3893 119.592 75.3726 119.73 75.4074C119.869 75.4422 119.991 75.5261 120.072 75.6435C120.154 75.7609 120.189 75.9037 120.173 76.0453Z"
                fill="white"
            />
            <path
                d="M123.292 88.3332C119.37 90.3841 116.267 93.7035 114.495 97.7442C114.441 97.8836 114.334 97.9967 114.198 98.0595C114.061 98.1224 113.906 98.1301 113.764 98.0812V98.0754C114.118 97.2446 116.401 87.8278 115.085 85.6087C117.227 84.5339 119.227 77.5338 119.788 75.4309C119.907 75.4821 120.008 75.5686 120.077 75.6787C120.145 75.7888 120.178 75.9173 120.171 76.0466C120.153 80.0957 120.891 84.8535 123.452 87.1947C123.529 87.2744 123.587 87.3705 123.621 87.4758C123.656 87.5811 123.666 87.6928 123.65 87.8025C123.635 87.9121 123.595 88.0169 123.533 88.1088C123.471 88.2008 123.388 88.2775 123.292 88.3332Z"
                fill="#D8E5FF"
            />
            <path
                d="M113.764 98.0752V98.081C113.645 98.0358 113.543 97.9553 113.471 97.8504C113.399 97.7455 113.362 97.6211 113.363 97.4943C113.151 92.0277 111.51 87.6185 110.266 85.8292C110.192 85.7246 110.147 85.6023 110.136 85.4749C111.763 85.8229 113.442 85.8683 115.086 85.6085C116.402 87.8276 114.118 97.2444 113.764 98.0752Z"
                fill="#ECF1FF"
            />
            <path
                d="M118.709 26.5477C120.616 23.8281 121.873 22.561 124.045 20.0001"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M124.066 27.0615C125.522 25.9134 128.619 23.4588 130.075 22.3107"
                stroke="#1CB5F9"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M57.6955 29.6874C57.648 29.6875 57.6007 29.6816 57.5546 29.6699C57.4833 29.652 57.4162 29.62 57.3572 29.5759C57.2981 29.5317 57.2483 29.4762 57.2107 29.4126C57.173 29.349 57.1481 29.2784 57.1376 29.2051C57.1271 29.1317 57.131 29.057 57.1492 28.9852L57.5634 27.3803C57.6026 27.2358 57.6963 27.1125 57.8246 27.0368C57.9528 26.9612 58.1053 26.9393 58.2494 26.9757C58.3207 26.9936 58.3879 27.0255 58.4469 27.0697C58.5059 27.1138 58.5557 27.1693 58.5934 27.233C58.6311 27.2966 58.6559 27.3671 58.6665 27.4405C58.677 27.5138 58.6731 27.5886 58.6548 27.6604L58.2406 29.2652C58.2088 29.3865 58.138 29.4937 58.0394 29.57C57.9408 29.6464 57.8198 29.6877 57.6955 29.6874Z"
                fill="#1CB5F9"
            />
            <path
                d="M56.5392 34.1666C56.4917 34.1667 56.4444 34.1608 56.3984 34.149C56.3271 34.1311 56.26 34.0992 56.2009 34.055C56.1419 34.0109 56.0921 33.9554 56.0544 33.8918C56.0167 33.8281 55.9919 33.7576 55.9814 33.6842C55.9708 33.6109 55.9748 33.5362 55.993 33.4644L56.4072 31.8595C56.4462 31.7149 56.5399 31.5914 56.6682 31.5158C56.7964 31.4401 56.949 31.4182 57.0932 31.4548C57.1645 31.4727 57.2316 31.5047 57.2906 31.5488C57.3497 31.593 57.3995 31.6485 57.4371 31.7121C57.4748 31.7757 57.4996 31.8463 57.5102 31.9196C57.5207 31.993 57.5168 32.0677 57.4986 32.1395L57.0844 33.7444C57.0525 33.8656 56.9818 33.9728 56.8832 34.0492C56.7845 34.1256 56.6636 34.1668 56.5392 34.1666Z"
                fill="#1CB5F9"
            />
            <path
                d="M60.3727 31.9085C60.3252 31.9086 60.2779 31.9027 60.2319 31.8909L58.624 31.4775C58.5527 31.4596 58.4855 31.4277 58.4265 31.3835C58.3675 31.3394 58.3177 31.2839 58.28 31.2202C58.2423 31.1566 58.2175 31.0861 58.2069 31.0127C58.1964 30.9394 58.2003 30.8646 58.2185 30.7928C58.2573 30.648 58.3509 30.5244 58.4793 30.4487C58.6076 30.373 58.7604 30.3513 58.9045 30.3882L60.5124 30.8016C60.6449 30.8348 60.7607 30.9159 60.8378 31.0294C60.9149 31.143 60.948 31.2812 60.9308 31.4177C60.9135 31.5543 60.8472 31.6797 60.7443 31.7701C60.6414 31.8606 60.5092 31.9099 60.3727 31.9085L60.3727 31.9085Z"
                fill="#1CB5F9"
            />
            <path
                d="M55.8845 30.7543C55.837 30.7545 55.7897 30.7486 55.7437 30.7368L54.1358 30.3239C54.0644 30.306 53.9973 30.2741 53.9382 30.23C53.8792 30.1858 53.8294 30.1303 53.7917 30.0667C53.754 30.003 53.7292 29.9325 53.7186 29.8591C53.7081 29.7858 53.7121 29.711 53.7303 29.6392C53.7691 29.4945 53.8628 29.3709 53.9911 29.2952C54.1194 29.2195 54.2722 29.1977 54.4163 29.2346L56.0242 29.6474C56.1567 29.6806 56.2725 29.7617 56.3496 29.8753C56.4267 29.9888 56.4598 30.127 56.4425 30.2635C56.4253 30.4001 56.359 30.5255 56.2561 30.616C56.1532 30.7064 56.021 30.7557 55.8845 30.7543L55.8845 30.7543Z"
                fill="#1CB5F9"
            />
            <path
                d="M132.466 92.7289C132.418 92.7291 132.371 92.7232 132.325 92.7114C132.254 92.6935 132.187 92.6615 132.128 92.6174C132.069 92.5732 132.019 92.5177 131.981 92.4541C131.943 92.3905 131.919 92.32 131.908 92.2466C131.898 92.1732 131.902 92.0985 131.92 92.0267L132.334 90.4218C132.373 90.2773 132.467 90.154 132.595 90.0784C132.723 90.0027 132.876 89.9808 133.02 90.0172C133.091 90.0351 133.158 90.067 133.217 90.1112C133.276 90.1553 133.326 90.2108 133.364 90.2745C133.402 90.3381 133.426 90.4086 133.437 90.482C133.448 90.5553 133.444 90.6301 133.425 90.7019L133.011 92.3067C132.979 92.428 132.909 92.5352 132.81 92.6115C132.711 92.6879 132.59 92.7292 132.466 92.7289Z"
                fill="#1CB5F9"
            />
            <path
                d="M131.31 97.2081C131.262 97.2082 131.215 97.2023 131.169 97.1905C131.098 97.1726 131.03 97.1407 130.971 97.0965C130.912 97.0524 130.863 96.9969 130.825 96.9333C130.787 96.8696 130.762 96.7991 130.752 96.7257C130.741 96.6524 130.745 96.5777 130.763 96.5059L131.178 94.901C131.217 94.7564 131.31 94.633 131.439 94.5573C131.567 94.4816 131.72 94.4597 131.864 94.4963C131.935 94.5142 132.002 94.5462 132.061 94.5903C132.12 94.6345 132.17 94.69 132.208 94.7536C132.245 94.8172 132.27 94.8878 132.281 94.9611C132.291 95.0345 132.287 95.1092 132.269 95.181L131.855 96.7859C131.823 96.9071 131.752 97.0143 131.654 97.0907C131.555 97.1671 131.434 97.2083 131.31 97.2081Z"
                fill="#1CB5F9"
            />
            <path
                d="M135.142 94.95C135.095 94.9501 135.047 94.9442 135.001 94.9324L133.394 94.519C133.322 94.5011 133.255 94.4692 133.196 94.425C133.137 94.3809 133.087 94.3254 133.05 94.2617C133.012 94.1981 132.987 94.1276 132.976 94.0542C132.966 93.9809 132.97 93.9061 132.988 93.8343C133.027 93.6895 133.12 93.5659 133.249 93.4902C133.377 93.4145 133.53 93.3928 133.674 93.4297L135.282 93.8431C135.414 93.8763 135.53 93.9574 135.607 94.0709C135.684 94.1845 135.718 94.3227 135.7 94.4592C135.683 94.5958 135.617 94.7212 135.514 94.8117C135.411 94.9021 135.279 94.9514 135.142 94.95L135.142 94.95Z"
                fill="#1CB5F9"
            />
            <path
                d="M130.654 93.7958C130.607 93.796 130.559 93.7901 130.513 93.7783L128.905 93.3654C128.834 93.3475 128.767 93.3156 128.708 93.2715C128.649 93.2273 128.599 93.1718 128.561 93.1082C128.524 93.0445 128.499 92.974 128.488 92.9006C128.478 92.8273 128.482 92.7525 128.5 92.6807C128.539 92.536 128.632 92.4124 128.761 92.3367C128.889 92.261 129.042 92.2392 129.186 92.2761L130.794 92.6889C130.926 92.7221 131.042 92.8032 131.119 92.9168C131.196 93.0303 131.229 93.1685 131.212 93.3051C131.195 93.4416 131.128 93.567 131.026 93.6575C130.923 93.7479 130.791 93.7972 130.654 93.7958L130.654 93.7958Z"
                fill="#1CB5F9"
            />
        </g>
        <defs>
            <linearGradient
                id="2a571356__paint0_linear_19033_12"
                x1={66.5748}
                y1={12.8891}
                x2={84.6034}
                y2={92.4098}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.393875} stopColor="#ECF2F9" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="2a571356__paint1_linear_19033_12"
                x1={92.2822}
                y1={76.1581}
                x2={101.357}
                y2={26.3676}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="2a571356__clip0_19033_12">
                <rect width={145} height={102} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default PromoSaleXs;
