import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SelfTransferL = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 220 220" fill="none" focusable={false} {...props}>
        <g clipPath="url(#5dae4683__clip0)">
            <path
                d="M154.998 174.211c-27.317 25.595-68.027 30.691-98.286 9.972-30.26-20.718-40.232-60.516-26.248-95.24"
                stroke="#fff"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M154.998 174.211c-27.317 25.595-68.027 30.691-98.286 9.972-30.26-20.718-40.232-60.516-26.248-95.24"
                stroke="#ECF2F9"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M52.078 57.382c27.316-25.596 68.026-30.692 98.284-9.973 30.258 20.719 40.229 60.52 26.247 95.245"
                stroke="#fff"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M52.078 57.382c27.316-25.596 68.026-30.692 98.284-9.973 30.258 20.719 40.229 60.52 26.247 95.245"
                stroke="#ECF2F9"
                strokeWidth={15}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M45.825 106.957L39.25 74.24c-.433-2.154-3.021-3.049-4.692-1.622L9.653 93.886c-1.677 1.432-1.187 4.141.886 4.895l31.48 11.449c2.111.767 4.249-1.071 3.806-3.273zM161.642 125.947l6.575 32.717c.433 2.154 3.022 3.048 4.692 1.622l24.905-21.269c1.677-1.432 1.187-4.14-.886-4.894l-31.48-11.449c-2.111-.767-4.249 1.071-3.806 3.273z"
                fill="#ECF2F9"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M123.236 45.047c-1.482-.083-3.403-.036-6.245.039l-1.296.034c-2.712.07-4.54.121-5.948.273-1.368.146-2.042.363-2.5.607-1.144.61-2.07 1.738-2.65 2.897-.232.465-.431 1.144-.542 2.515-.218 2.7-.347 5.38-.347 8.088 0 1.916-1.323 3.387-3.239 3.387A3.47 3.47 0 0197 59.417v-2.19c0-2.538 0-4.648.14-6.373.145-1.798.458-3.472 1.25-5.058a13.18 13.18 0 015.594-5.742c1.564-.834 3.229-1.19 5.023-1.383 1.72-.185 3.83-.24 6.367-.306l1.579-.042c2.662-.07 4.87-.127 6.673-.026 1.874.105 3.623.393 5.278 1.198a13.181 13.181 0 015.93 5.777c.849 1.633 1.182 3.373 1.336 5.245.149 1.8.149 4.008.149 6.671v2.23a3.47 3.47 0 01-6.939 0v-2.086c0-2.843-.003-4.764-.125-6.244-.119-1.44-.333-2.145-.578-2.618-.618-1.19-1.603-2.327-2.809-2.914-.479-.233-1.189-.428-2.632-.509z"
                fill="#292929"
            />
            <path
                d="M103.999 51.115L103.707 59h-2.5l.83-7.746a7 7 0 016.96-6.254h12.71l-11.883.34a6 6 0 00-5.825 5.775z"
                fill="#000"
                fillOpacity={0.69}
            />
            <path
                d="M135.207 46c1.888 4.248 1.5 13.5 1.5 13.5h-2.5s.66-6-.5-11.5c-1.16-5.5-4-8-4-8s3.612 1.752 5.5 6z"
                fill="#000"
            />
            <path
                d="M65.08 152.93c2.15-.657 3.712 3.277 5.084 5.421 3.7 5.782 6.014 10.177 6.014 12.721 0 3.238-.167 7.525-3.198 9.371a11.42 11.42 0 01-7.097.185c-2.64-.713-6.59-6.21-6.59-13.872 0-7.661 2.205-12.683 5.787-13.826z"
                fill="#292929"
            />
            <g filter="url(#5dae4683__filter0_i)">
                <path
                    d="M79.177 60.682l-9.162 3.804A13 13 0 0062 76.492V161.2c0 10.935 8.865 19.8 19.8 19.8h49.947c5.39 0 10.547-2.197 14.28-6.084l4.453-4.637a19.797 19.797 0 005.52-13.715V72c0-7.18-5.82-13-13-13H87.613a22 22 0 00-8.436 1.682z"
                    fill="url(#5dae4683__paint0_linear)"
                />
            </g>
            <path
                d="M62 78c0-6.075 4.925-11 11-11h60c6.075 0 11 4.925 11 11v92c0 6.075-4.925 11-11 11H81.8c-10.935 0-19.8-8.865-19.8-19.8V78z"
                fill="url(#5dae4683__paint1_linear)"
            />
            <path
                d="M77 79a4 4 0 014-4v99a4 4 0 01-4-4V79z"
                fill="url(#5dae4683__paint2_linear)"
            />
            <path
                d="M93 79a4 4 0 014-4v99a4 4 0 01-4-4V79z"
                fill="url(#5dae4683__paint3_linear)"
            />
            <path
                d="M109 79a4 4 0 014-4v99a4 4 0 01-4-4V79z"
                fill="url(#5dae4683__paint4_linear)"
            />
            <path
                d="M125 79a4 4 0 014-4v99a4 4 0 01-4-4V79z"
                fill="url(#5dae4683__paint5_linear)"
            />
            <path
                d="M58.42 113.227c.101-.012-5.09.299-5.09.299s3.342-10.665 14.438-7.88c-8.527.708-9.348 7.581-9.348 7.581z"
                fill="url(#5dae4683__paint6_linear)"
            />
            <g filter="url(#5dae4683__filter1_i)">
                <path
                    d="M27.579 172.752c8.906 12.798 18.6 20.165 35.18 19.935 6.25-.026 18.539-2.722 21.326-4.286 10.742-6.207 8.88-61.424 1.46-71.218-7.42-9.793-34.626-8.4-43.622-3.016-8.995 5.383-24.603 43.894-14.344 58.585z"
                    fill="#FFD34D"
                />
            </g>
            <path
                d="M75.754 115.885l-5.122-.827c-.025-4.514-1.745-8.621-7.218-9.817 11.175.003 12.496 7.648 12.34 10.644z"
                fill="#66B3FF"
            />
            <path
                d="M46.751 124.576c-.558.477-1.503 4.593-.913 5.242.578.547 8.655 1.227 9.124.863.47-.363 1.633-5.225 1.067-5.671-.565-.446-8.72-.911-9.278-.434z"
                fill="#0066DA"
            />
            <path
                d="M62.126 190.811c8.26-4.68 9.826-43.16 6.718-49.463-3.121-6.404-35.88-7.738-41.504-2.448-7.108 6.596-10.882 33.43-9.275 41.76 1.697 8.217 35.79 14.73 44.061 10.151z"
                fill="#FFD34D"
                stroke="url(#5dae4683__paint7_linear)"
                strokeWidth={2}
                strokeMiterlimit={10}
            />
            <path
                d="M86.387 151.783c.158-5.562-.113-11.279-.675-16.859-.35-2.935-.712-5.972-1.365-8.872-.455-2.101-1.125-4.28-2.365-6.083-1.24-1.803-3.442-3.081-5.293-3.989-2.393-1.153-4.94-1.876-7.474-2.498-5.461-1.095-11.13-1.344-16.725-.985-2.539.2-5.078.4-7.581.903-1.504.282-3.21.588-4.541 1.465-.95.627.128 1.935 1.09 1.41.76-.501 2.265-.783 3.365-1.017 1.997-.443 4.019-.684 6.053-.823 5.179-.412 10.52-.33 15.63.396 4.705.774 9.988 2.096 13.467 5.48 1.382 1.273 1.914 3.16 2.434 4.946.73 2.685 1.157 5.406 1.483 8.139.711 5.973 1.03 12.094.832 18.175-.082 1.037 1.596 1.35 1.665.212zM63.665 151.772c-7.557-.084-15.136-.473-22.641-1.277a154.425 154.425 0 01-9.572-1.169c-2.168-.359-4.337-.718-6.424-1.39-1.044-.336-1.859 1.152-.807 1.59 2.095.773 4.364 1.125 6.532 1.484 3.3.484 6.592.867 9.884 1.25 7.709.789 15.389 1.171 23.055 1.35 1.219-.086 1.098-1.814-.027-1.838z"
                fill="#FAAC1A"
            />
            <path
                d="M63.075 152.301c1.827.707 2.404 8.132 1.83 9.33-.677 1.21-5.387 1.258-5.604-.564-.306-1.709 1.846-9.46 3.774-8.766z"
                fill="#FAAC1A"
            />
            <path
                d="M30.335 74.327c2.557 1.022 7.792 3.19 8.283 3.68.614.614 5.829 11.045 5.215 11.965-.613.92-6.53-.307-7.144-.92-.613-.614-14.023-15.646-15.25-16.26-1.227-.613-7.363-2.453-8.283-3.067-.92-.613-3.681-3.988-3.068-4.908.614-.92 3.9-2.761 7.581-2.761 3.068 0 26.69 8.59 26.997 8.283.306-.307 7.669-4.602 8.896-4.295.982.245 3.053 1.227 4.69 1.84-1.886 2.761-11.486 11.204-16.346 9.513"
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M25.031 63.59C28.1 60.93 34.875 55 35.856 55c1.227 0 6.443.92 6.136 2.147-.245.982-2.542 8.283-3.463 11.044"
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M199.805 115.617c.465-.432 2.408-2.146 2.85-2.581a1.05 1.05 0 011.522.034c2.193 2.386 7.701 8.735 9.876 11.211.371.422.377 1.063.014 1.495-1.879 2.233-5.594 6.263-6.556 7.135a.331.331 0 01-.352.058c-.724-.284-1.527-.226-1.998.324-.347.405-.358 1.121-.258 1.534a.36.36 0 01-.095.349c-1.535 1.484-14.17 11.029-23.253 15.08a1.058 1.058 0 01-1.33-.417c-.063-.1-1.156-1.724-1.225-1.839"
                stroke="#00E6C5"
                strokeWidth={2}
            />
            <path
                d="M167.006 136.983h0a.115.115 0 00-.029.163h0c1.991 2.829 7.922 10.101 9.999 12.2l.011.005a.197.197 0 00.062.016.219.219 0 00.064-.001l.01-.003c4.878-3.086 9.792-7.239 13.669-10.866 3.553-3.324 6.179-6.151 7.092-7.264-.148-.542-.182-1.262.12-1.914l-30.998 7.664zm0 0c2.751-1.929 6.612-4.963 10.249-8.103 3.485-3.01 6.826-6.169 8.785-8.573m-19.034 16.676l19.034-16.676m19.481.054h0a1112.79 1112.79 0 01-2.679-2.101c-3.104-2.436-7.295-5.727-9.249-7.182h0a.113.113 0 00-.16.027s0 0 0 0l-.802-.597 12.89 9.853zm0 0a.104.104 0 01.026.139c-1.363 2.269-3.848 6.118-4.831 7.462m4.805-7.601l-4.805 7.601m-14.676-7.655c.82.036 1.712-.171 2.331-.954l-2.331.954zm14.676 7.655c-.93-.083-2.152.152-2.712 1.357l2.712-1.357zm-2.617 2.999h0z"
                stroke="#00E6C5"
                strokeWidth={2}
            />
            <path
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                strokeDasharray="0.02 4"
                d="M191.029 121.339l4.586 4.586"
            />
            <path
                stroke="#00E6C5"
                strokeWidth={2}
                strokeLinecap="round"
                d="M178.149 42.987l3.661-1.009M168.089 45.76l3.661-1.009M172.978 37.151l1.009 3.661M175.751 47.211l1.009 3.661"
            />
            <path
                d="M156.483 150.066c-2.101-.518-3.408 2.095-3.482 4.73-.466 16.563-6.985 17.552-6.985 20.186 0 .517-.268 1.666 1.397 3.105s6.662 1.681 8.832.963c2.17-.718 3.726-6.561 3.726-14.492 0-7.93-.992-13.877-3.488-14.492z"
                fill="url(#5dae4683__paint8_linear)"
            />
            <path
                d="M156.513 150.066c-2.101-.518-3.408 2.095-3.482 4.73-.171 6.09-1.161 10.075-2.344 12.81-.496 7.238 1.391 12.388 5.588 11.444 2.17-.718 3.726-6.561 3.726-14.492 0-7.93-.992-13.877-3.488-14.492z"
                fill="#292929"
            />
        </g>
        <defs>
            <linearGradient
                id="5dae4683__paint4_linear"
                x1={108.368}
                y1={115.85}
                x2={129.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.13} stopColor="#F74D30" />
                <stop offset={0.234} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint0_linear"
                x1={127.962}
                y1={129.28}
                x2={88.608}
                y2={67.833}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint1_linear"
                x1={144.056}
                y1={187.636}
                x2={58.648}
                y2={87.264}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.003} stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint2_linear"
                x1={76.368}
                y1={115.85}
                x2={97.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.13} stopColor="#F74D30" />
                <stop offset={0.234} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint3_linear"
                x1={92.368}
                y1={115.85}
                x2={113.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.13} stopColor="#F74D30" />
                <stop offset={0.234} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint5_linear"
                x1={124.368}
                y1={115.85}
                x2={145.687}
                y2={115.85}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6A3C" />
                <stop offset={0.13} stopColor="#F74D30" />
                <stop offset={0.234} stopColor="#F74D30" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint6_linear"
                x1={53.249}
                y1={109.479}
                x2={67.854}
                y2={109.101}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.091} stopColor="#0065D9" />
                <stop offset={0.7} stopColor="#027BF3" />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint7_linear"
                x1={65.001}
                y1={188}
                x2={21.501}
                y2={121}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FAAC1A" />
                <stop offset={1} stopColor="#FFD34D" />
            </linearGradient>
            <linearGradient
                id="5dae4683__paint8_linear"
                x1={146}
                y1={175.361}
                x2={159.117}
                y2={173.254}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#292929" />
                <stop offset={0.432} stopColor="#5B5B5B" />
                <stop offset={1} stopColor="#292929" />
            </linearGradient>
            <filter
                id="5dae4683__filter0_i"
                x={57}
                y={51}
                width={99}
                height={130}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feColorMatrix
                    in="SourceAlpha"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dx={-5} dy={-8} />
                <feGaussianBlur stdDeviation={6} />
                <feComposite
                    in2="hardAlpha"
                    operator="arithmetic"
                    k2={-1}
                    k3={1}
                />
                <feColorMatrix values="0 0 0 0 0.579167 0 0 0 0 0.0927356 0 0 0 0 0.086875 0 0 0 1 0" />
                <feBlend in2="shape" result="effect1_innerShadow" />
            </filter>
            <filter
                id="5dae4683__filter1_i"
                x={19.121}
                y={104.879}
                width={72.505}
                height={87.813}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feColorMatrix
                    in="SourceAlpha"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dx={-5.088} dy={-5.088} />
                <feGaussianBlur stdDeviation={4.857} />
                <feComposite
                    in2="hardAlpha"
                    operator="arithmetic"
                    k2={-1}
                    k3={1}
                />
                <feColorMatrix values="0 0 0 0 0.95 0 0 0 0 0.639872 0 0 0 0 0.059375 0 0 0 1 0" />
                <feBlend in2="shape" result="effect1_innerShadow" />
            </filter>
            <clipPath id="5dae4683__clip0">
                <path fill="#fff" d="M0 0h220v220H0z" />
            </clipPath>
        </defs>
    </svg>
);

export default SelfTransferL;
