import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SerpBudapestBadgeM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 72 60"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect width={72} height={58.8889} rx={8} fill="white" />
        <mask
            id="f834d0da__mask0_16290_135"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={72}
            height={60}
        >
            <rect width={72} height={60} rx={8} fill="white" />
        </mask>
        <g mask="url(#f834d0da__mask0_16290_135)">
            <path
                d="M64.4986 37.715L53.1543 48.7739L63.6544 59.0098L74.9986 47.9509L64.4986 37.715Z"
                fill="white"
            />
            <path
                d="M74.5751 58.5468C69.184 63.8022 60.4434 63.8022 55.0524 58.5468C49.6613 53.2914 49.6613 44.7706 55.0524 39.5152C60.4434 34.2598 69.184 34.2598 74.5751 39.5152C79.9661 44.7706 79.9661 53.2914 74.5751 58.5468ZM63.4944 56.4595C64.8925 56.4561 67.1778 55.0447 69.0876 53.1973C70.9825 51.3357 72.4305 49.1078 72.4339 47.7449C72.4425 44.3588 61.573 42.014 59.5868 43.9314C57.6157 45.8718 60.0209 56.4679 63.4944 56.4595Z"
                fill="url(#f834d0da__paint0_linear_16290_135)"
            />
            <path
                d="M71.6581 -7.42233C69.2628 -9.71411 65.3792 -9.71411 62.9839 -7.42232L51.9504 3.1345C49.5551 5.42628 49.5551 9.14201 51.9504 11.4338L62.984 21.9907C65.3793 24.2825 69.2628 24.2825 71.6581 21.9907L82.6917 11.4338C85.087 9.14205 85.087 5.42631 82.6917 3.13452L71.6581 -7.42233Z"
                fill="#FFCC00"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M76.513 12.8322C74.9443 14.7363 72.7588 16.155 70.2458 16.7375C69.5311 16.9024 68.8008 16.9973 68.0661 17.0206C65.8709 17.0884 63.703 16.5403 61.8294 15.4439C59.3806 14.0079 57.676 11.7867 57.028 9.19016C56.4136 6.67155 56.8684 4.02259 58.2925 1.82435C59.6699 -0.299789 61.7918 -1.76788 64.2676 -2.30999C66.6658 -2.82176 69.1782 -2.40302 71.2543 -1.14554C73.2536 0.0647729 74.628 1.91268 75.1257 4.05669C75.3579 5.07876 75.3772 6.13462 75.1823 7.16381C74.9874 8.193 74.5823 9.1753 73.99 10.0545C72.8468 11.7492 71.1139 12.9017 69.1095 13.2999C68.1571 13.4845 67.176 13.4875 66.2224 13.3088C65.2688 13.1301 64.3615 12.7731 63.5523 12.2584C62.0038 11.2719 60.9617 9.79631 60.6172 8.10329C60.4577 7.30526 60.4655 6.48488 60.64 5.68974C60.8145 4.8946 61.1523 4.14054 61.6338 3.47131C62.5458 2.20809 63.8928 1.37494 65.4265 1.12467C66.1455 1.00985 66.8812 1.03336 67.5906 1.19382C68.3 1.35428 68.9689 1.64847 69.558 2.05919C70.6537 2.82607 71.3583 3.93356 71.542 5.17731C71.6263 5.75439 71.5876 6.34185 71.428 6.90418C71.2684 7.46651 70.9913 7.99205 70.6134 8.44905C70.2857 8.85215 69.8748 9.18642 69.4063 9.43107C68.9377 9.67573 68.4216 9.82554 67.89 9.87118C67.3971 9.90971 66.9013 9.85082 66.4332 9.69817C65.9652 9.54553 65.5349 9.30239 65.1693 8.98387C64.8603 8.71655 64.6139 8.3897 64.4463 8.02481C64.2787 7.65991 64.1936 7.26521 64.1967 6.86664C64.2047 6.11742 64.6033 5.35079 65.2115 4.91376C65.4559 4.73281 65.7412 4.60928 66.0446 4.55312C66.348 4.49696 66.6609 4.50975 66.9582 4.59044C67.0823 4.62289 67.1986 4.67846 67.3003 4.75396C67.4019 4.82946 67.487 4.9234 67.5507 5.03042C67.6144 5.13744 67.6554 5.25542 67.6713 5.37762C67.6873 5.49981 67.6779 5.62382 67.6437 5.74253C67.6094 5.86124 67.5511 5.97233 67.4719 6.06943C67.3928 6.16653 67.2944 6.24774 67.1824 6.30841C67.0704 6.36907 66.947 6.408 66.8192 6.42296C66.6915 6.43793 66.5619 6.42863 66.4379 6.39561C66.4236 6.39171 66.4156 6.39435 66.3901 6.41283C66.3198 6.47354 66.2629 6.54697 66.2224 6.62886C66.182 6.71075 66.1589 6.79949 66.1546 6.88995C66.1538 7.02668 66.1841 7.16194 66.2434 7.28634C66.3027 7.41074 66.3896 7.52131 66.498 7.61039C66.663 7.75085 66.8559 7.85811 67.0652 7.92578C67.2744 7.99346 67.4957 8.02016 67.716 8.00429C67.9831 7.98034 68.2422 7.90368 68.4768 7.77914C68.7114 7.65461 68.9165 7.48489 69.0791 7.28072C69.2906 7.02185 69.4459 6.72511 69.5357 6.40797C69.6255 6.09082 69.6481 5.7597 69.6022 5.43407C69.5442 5.06227 69.4082 4.70552 69.2024 4.38528C68.9966 4.06503 68.7253 3.78789 68.4048 3.57051C68.028 3.30718 67.6 3.11853 67.1459 3.01564C66.6918 2.91274 66.2208 2.89768 65.7606 2.97133C64.7492 3.13613 63.8566 3.69301 63.2465 4.53827C62.9123 5.00211 62.6777 5.52484 62.5563 6.07613C62.4349 6.62742 62.4291 7.19629 62.5393 7.74973C62.7826 8.94622 63.5269 9.994 64.6344 10.6995C65.2271 11.0772 65.8919 11.3392 66.5907 11.4706C67.2895 11.6019 68.0085 11.6 68.7065 11.4649C70.1953 11.1691 71.4869 10.3062 72.344 9.03535C72.7965 8.36454 73.1062 7.61494 73.2554 6.82947C73.4047 6.04399 73.3905 5.23806 73.2138 4.45782C72.8307 2.80502 71.7635 1.37691 70.2105 0.43649C68.5762 -0.55449 66.5981 -0.885493 64.7092 -0.484044C62.745 -0.0538657 61.0577 1.11762 59.9575 2.81462C58.8069 4.58829 58.4385 6.72617 58.9331 8.75937C59.4586 10.867 60.85 12.6735 62.8499 13.8469C64.9277 15.0657 67.4537 15.4557 69.7801 14.9162C71.8683 14.432 73.6843 13.25 74.9879 11.6628C76.3378 10.027 77.0879 8.01189 77.1226 5.92798C78.4278 5.95337 79.0804 5.96609 79.0805 5.96613C79.0359 8.46247 78.1336 10.8753 76.513 12.8322Z"
                fill="black"
            />
            <ellipse
                cx={5.80658}
                cy={9.99959}
                rx={13.9355}
                ry={13.3333}
                fill="#FFCC00"
            />
            <path
                d="M0.152027 14.7207L11.6628 4.52832L13.5813 5.02402L2.07057 15.2164L0.152027 14.7207ZM7.21426 6.71616C6.92963 7.72463 6.47371 8.43961 5.84649 8.86111C5.23111 9.28567 4.52076 9.39391 3.71545 9.18584C2.91014 8.97777 2.34258 8.55758 2.01278 7.92529C1.68618 7.28166 1.66679 6.44995 1.95461 5.43015C2.24564 4.39901 2.70316 3.67836 3.32718 3.2682C3.95441 2.8467 4.67067 2.73998 5.47599 2.94806C6.2813 3.15613 6.84134 3.58045 7.1561 4.22101C7.4859 4.85331 7.50529 5.68502 7.21426 6.71616ZM3.81169 5.87349C3.6326 6.50804 3.57141 6.97244 3.62813 7.26672C3.68804 7.54966 3.84827 7.72479 4.10881 7.79211C4.36935 7.85943 4.59994 7.78527 4.80057 7.56965C5.0044 7.34269 5.19586 6.91194 5.37495 6.2774C5.55724 5.63152 5.61843 5.16712 5.55851 4.88417C5.51044 4.60429 5.35021 4.42916 5.07783 4.35878C4.80544 4.2884 4.56893 4.36103 4.36831 4.57665C4.17952 4.79534 3.99398 5.22762 3.81169 5.87349ZM11.7418 14.378C11.4571 15.3865 11.0012 16.1015 10.374 16.523C9.7586 16.9475 9.04825 17.0558 8.24294 16.8477C7.44947 16.6427 6.88351 16.2168 6.54507 15.5701C6.21846 14.9265 6.19748 14.1005 6.4821 13.092C6.77313 12.0609 7.23065 11.3402 7.85467 10.93C8.49374 10.5116 9.21001 10.4049 10.0035 10.6099C10.8088 10.818 11.3688 11.2423 11.6836 11.8829C12.0134 12.5152 12.0328 13.3469 11.7418 14.378ZM8.33918 13.5353C8.16009 14.1699 8.1005 14.6286 8.16041 14.9116C8.23217 15.1976 8.3924 15.3727 8.6411 15.437C8.91349 15.5073 9.14999 15.4347 9.35062 15.2191C9.55125 15.0035 9.74111 14.5784 9.9202 13.9438C10.0993 13.3093 10.1589 12.8505 10.099 12.5676C10.0423 12.2733 9.8777 12.091 9.60532 12.0206C9.34477 11.9533 9.11259 12.0331 8.90876 12.2601C8.70813 12.4757 8.51827 12.9008 8.33918 13.5353Z"
                fill="black"
            />
            <g clipPath="url(#f834d0da__clip0_16290_135)">
                <path
                    d="M4.61107 32.2222L-15.0967 51.0784L4.61107 69.9345L24.3188 51.0784L4.61107 32.2222Z"
                    fill="url(#f834d0da__paint1_linear_16290_135)"
                />
                <g filter="url(#f834d0da__filter0_d_16290_135)">
                    <path
                        d="M9.32294 60.7465C7.32429 61.6376 5.09433 61.9417 2.91507 61.6202C0.735806 61.2987 -1.29488 60.3662 -2.92017 58.9404C-4.54546 57.5147 -5.69236 55.6598 -6.21582 53.6104C-6.73928 51.5609 -6.6158 49.409 -5.86099 47.4267C-5.10617 45.4445 -3.75393 43.7209 -1.97527 42.4739C-0.196613 41.227 1.92857 40.5127 4.13152 40.4214C6.33447 40.3302 8.51623 40.866 10.4009 41.9611C12.2856 43.0563 13.7885 44.6616 14.7196 46.574C15.968 49.1381 16.1008 52.0717 15.0887 54.7295C14.0767 57.3873 12.0027 59.5517 9.32294 60.7465ZM0.23438 51.5604C0.734735 51.3386 1.15509 50.9798 1.44225 50.5294C1.72941 50.079 1.87047 49.5572 1.84758 49.03C1.8247 48.5029 1.63889 47.9941 1.31367 47.568C0.988449 47.1419 0.53844 46.8177 0.0205853 46.6364C-0.497269 46.4551 -1.0597 46.4249 -1.59552 46.5495C-2.13134 46.6742 -2.61648 46.9481 -2.98955 47.3366C-3.36261 47.7252 -3.60684 48.2108 -3.69131 48.7322C-3.77578 49.2536 -3.69671 49.7872 -3.46411 50.2656C-3.15264 50.9062 -2.58823 51.4023 -1.89481 51.645C-1.20138 51.8878 -0.43561 51.8573 0.23438 51.5604ZM7.81201 48.1799C8.31158 47.957 8.73084 47.5973 9.01677 47.1464C9.30269 46.6955 9.44245 46.1735 9.41836 45.6466C9.39427 45.1197 9.20741 44.6115 8.88143 44.1862C8.55544 43.7609 8.10496 43.4376 7.58695 43.2573C7.06895 43.0769 6.50668 43.0476 5.97125 43.173C5.43582 43.2984 4.95129 43.5729 4.57891 43.9618C4.20653 44.3506 3.96304 44.8364 3.87923 45.3577C3.79542 45.879 3.87505 46.4124 4.10805 46.8903C4.26276 47.2077 4.48128 47.4928 4.75115 47.7294C5.02102 47.966 5.33695 48.1493 5.68089 48.2691C6.02484 48.3888 6.39007 48.4426 6.75572 48.4273C7.12138 48.412 7.48031 48.3279 7.81201 48.1799ZM11.3474 55.428C11.8469 55.2051 12.2662 54.8454 12.5521 54.3945C12.838 53.9436 12.9778 53.4217 12.9537 52.8947C12.9296 52.3678 12.7428 51.8596 12.4168 51.4343C12.0908 51.009 11.6403 50.6857 11.1223 50.5054C10.6043 50.325 10.042 50.2957 9.5066 50.4211C8.97117 50.5465 8.48664 50.821 8.11426 51.2099C7.74188 51.5987 7.49839 52.0845 7.41458 52.6058C7.33077 53.1271 7.4104 53.6605 7.6434 54.1385C7.79811 54.4558 8.01664 54.7409 8.28651 54.9775C8.55637 55.2141 8.8723 55.3975 9.21624 55.5172C9.56019 55.6369 9.92542 55.6907 10.2911 55.6754C10.6567 55.6601 11.0157 55.576 11.3474 55.428ZM3.76754 58.8106C4.26735 58.5878 4.68685 58.2281 4.97296 57.7771C5.25907 57.3261 5.39893 56.804 5.37485 56.277C5.35077 55.7499 5.16382 55.2415 4.83766 54.8161C4.51151 54.3907 4.0608 54.0675 3.54257 53.8872C3.02434 53.707 2.46188 53.6779 1.92636 53.8036C1.39083 53.9293 0.906315 54.2041 0.534104 54.5934C0.161892 54.9826 -0.0812803 55.4688 -0.164646 55.9903C-0.248011 56.5118 -0.167825 57.0452 0.0657702 57.5231C0.378625 58.1632 0.944188 58.6583 1.63825 58.8997C2.33232 59.1411 3.09814 59.109 3.76754 58.8106ZM5.20073 52.2874C5.45046 52.1759 5.66003 51.9961 5.80295 51.7706C5.94586 51.5452 6.01571 51.2843 6.00367 51.0209C5.99162 50.7574 5.89822 50.5034 5.73527 50.2907C5.57231 50.0781 5.34713 49.9165 5.08818 49.8263C4.82924 49.7361 4.54815 49.7213 4.28046 49.784C4.01277 49.8466 3.7705 49.9838 3.58427 50.1781C3.39804 50.3725 3.27621 50.6153 3.2342 50.8759C3.19218 51.1364 3.23185 51.4031 3.34821 51.6421C3.42551 51.8009 3.53476 51.9436 3.66971 52.0619C3.80467 52.1803 3.96268 52.2721 4.13472 52.332C4.30676 52.392 4.48946 52.4189 4.67237 52.4112C4.85528 52.4035 5.03482 52.3615 5.20073 52.2874Z"
                        fill="black"
                    />
                </g>
                <path
                    d="M9.32294 60.7465C7.32429 61.6376 5.09433 61.9417 2.91507 61.6202C0.735806 61.2987 -1.29488 60.3662 -2.92017 58.9404C-4.54546 57.5147 -5.69236 55.6598 -6.21582 53.6104C-6.73928 51.5609 -6.6158 49.409 -5.86099 47.4267C-5.10617 45.4445 -3.75393 43.7209 -1.97527 42.4739C-0.196613 41.227 1.92857 40.5127 4.13152 40.4214C6.33447 40.3302 8.51623 40.866 10.4009 41.9611C12.2856 43.0563 13.7885 44.6616 14.7196 46.574C15.968 49.1381 16.1008 52.0717 15.0887 54.7295C14.0767 57.3873 12.0027 59.5517 9.32294 60.7465ZM0.23438 51.5604C0.734735 51.3386 1.15509 50.9798 1.44225 50.5294C1.72941 50.079 1.87047 49.5572 1.84758 49.03C1.8247 48.5029 1.63889 47.9941 1.31367 47.568C0.988449 47.1419 0.53844 46.8177 0.0205853 46.6364C-0.497269 46.4551 -1.0597 46.4249 -1.59552 46.5495C-2.13134 46.6742 -2.61648 46.9481 -2.98955 47.3366C-3.36261 47.7252 -3.60684 48.2108 -3.69131 48.7322C-3.77578 49.2536 -3.69671 49.7872 -3.46411 50.2656C-3.15264 50.9062 -2.58823 51.4023 -1.89481 51.645C-1.20138 51.8878 -0.43561 51.8573 0.23438 51.5604ZM7.81201 48.1799C8.31158 47.957 8.73084 47.5973 9.01677 47.1464C9.30269 46.6955 9.44245 46.1735 9.41836 45.6466C9.39427 45.1197 9.20741 44.6115 8.88143 44.1862C8.55544 43.7609 8.10496 43.4376 7.58695 43.2573C7.06895 43.0769 6.50668 43.0476 5.97125 43.173C5.43582 43.2984 4.95129 43.5729 4.57891 43.9618C4.20653 44.3506 3.96304 44.8364 3.87923 45.3577C3.79542 45.879 3.87505 46.4124 4.10805 46.8903C4.26276 47.2077 4.48128 47.4928 4.75115 47.7294C5.02102 47.966 5.33695 48.1493 5.68089 48.2691C6.02484 48.3888 6.39007 48.4426 6.75572 48.4273C7.12138 48.412 7.48031 48.3279 7.81201 48.1799ZM11.3474 55.428C11.8469 55.2051 12.2662 54.8454 12.5521 54.3945C12.838 53.9436 12.9778 53.4217 12.9537 52.8947C12.9296 52.3678 12.7428 51.8596 12.4168 51.4343C12.0908 51.009 11.6403 50.6857 11.1223 50.5054C10.6043 50.325 10.042 50.2957 9.5066 50.4211C8.97117 50.5465 8.48664 50.821 8.11426 51.2099C7.74188 51.5987 7.49839 52.0845 7.41458 52.6058C7.33077 53.1271 7.4104 53.6605 7.6434 54.1385C7.79811 54.4558 8.01664 54.7409 8.28651 54.9775C8.55637 55.2141 8.8723 55.3975 9.21624 55.5172C9.56019 55.6369 9.92542 55.6907 10.2911 55.6754C10.6567 55.6601 11.0157 55.576 11.3474 55.428ZM3.76754 58.8106C4.26735 58.5878 4.68685 58.2281 4.97296 57.7771C5.25907 57.3261 5.39893 56.804 5.37485 56.277C5.35077 55.7499 5.16382 55.2415 4.83766 54.8161C4.51151 54.3907 4.0608 54.0675 3.54257 53.8872C3.02434 53.707 2.46188 53.6779 1.92636 53.8036C1.39083 53.9293 0.906315 54.2041 0.534104 54.5934C0.161892 54.9826 -0.0812803 55.4688 -0.164646 55.9903C-0.248011 56.5118 -0.167825 57.0452 0.0657702 57.5231C0.378625 58.1632 0.944188 58.6583 1.63825 58.8997C2.33232 59.1411 3.09814 59.109 3.76754 58.8106ZM5.20073 52.2874C5.45046 52.1759 5.66003 51.9961 5.80295 51.7706C5.94586 51.5452 6.01571 51.2843 6.00367 51.0209C5.99162 50.7574 5.89822 50.5034 5.73527 50.2907C5.57231 50.0781 5.34713 49.9165 5.08818 49.8263C4.82924 49.7361 4.54815 49.7213 4.28046 49.784C4.01277 49.8466 3.7705 49.9838 3.58427 50.1781C3.39804 50.3725 3.27621 50.6153 3.2342 50.8759C3.19218 51.1364 3.23185 51.4031 3.34821 51.6421C3.42551 51.8009 3.53476 51.9436 3.66971 52.0619C3.80467 52.1803 3.96268 52.2721 4.13472 52.332C4.30676 52.392 4.48946 52.4189 4.67237 52.4112C4.85528 52.4035 5.03482 52.3615 5.20073 52.2874Z"
                    fill="white"
                />
            </g>
        </g>
        <g clipPath="url(#f834d0da__clip1_16290_135)">
            <path
                d="M30.7291 34.1844C23.3546 27.8312 22.4687 24.3466 22.607 22.5752C22.4707 24.2837 22.5914 26.4872 22.751 29.4009C23.0745 35.3065 23.2364 38.2619 25.2526 40.0039C27.274 41.7403 30.3629 41.5854 36.5353 41.276C39.5805 41.1232 41.8835 41.0078 43.6451 40.6995C41.8183 41.0163 38.1037 40.5375 30.7291 34.1844Z"
                fill="url(#f834d0da__paint2_linear_16290_135)"
            />
            <path
                d="M46.4446 17.4844C44.4232 15.748 41.3343 15.9029 35.162 16.2124C28.9896 16.5219 25.9007 16.6768 24.0801 18.6059C23.1651 19.5837 22.7515 20.8245 22.6066 22.5753C22.4683 24.3467 23.3369 27.8165 30.7287 34.1845C38.1205 40.5525 41.8181 41.0215 43.6447 40.6996C45.4497 40.384 46.6962 39.8607 47.6167 38.8825C49.4315 36.9485 49.2696 33.993 48.9462 28.0874C48.6227 22.1818 48.4608 19.2264 46.4446 17.4844Z"
                fill="url(#f834d0da__paint3_linear_16290_135)"
            />
            <path
                d="M39.8123 38.0697C39.7953 37.9606 39.7784 37.8515 39.7612 37.7372C38.9387 32.4116 38.53 29.7461 36.5259 28.0244C34.5269 26.2973 31.7135 26.1871 26.0919 25.9611C25.9767 25.9564 25.8561 25.952 25.7409 25.9473C23.8926 25.8724 22.468 24.3417 22.6066 22.5754C22.5401 22.961 22.5131 23.3655 22.5833 23.7495C22.7296 24.6217 23.0454 25.4908 23.3991 26.1537C24.3933 28.0202 26.4271 30.9812 30.465 34.4648C34.5026 37.9433 37.7984 39.5687 39.837 40.32C40.5631 40.5872 41.4994 40.7968 42.4214 40.8448C42.8278 40.8716 43.2452 40.7983 43.6392 40.7C41.8233 41.0162 40.0833 39.8207 39.8123 38.0697Z"
                fill="url(#f834d0da__paint4_linear_16290_135)"
            />
        </g>
        <defs>
            <filter
                id="f834d0da__filter0_d_16290_135"
                x={-16.5342}
                y={32.4114}
                width={42.2969}
                height={41.3335}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={2} />
                <feGaussianBlur stdDeviation={5} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_16290_135"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_16290_135"
                    result="shape"
                />
            </filter>
            <linearGradient
                id="f834d0da__paint0_linear_16290_135"
                x1={64.8137}
                y1={68.0626}
                x2={64.8137}
                y2={29.9994}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C926FF" />
                <stop offset={1} stopColor="#4A26FF" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint1_linear_16290_135"
                x1={10.9394}
                y1={63.8796}
                x2={-0.786809}
                y2={37.836}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF6600" />
                <stop offset={1} stopColor="#FF9900" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint2_linear_16290_135"
                x1={23.4375}
                y1={41.9327}
                x2={41.6698}
                y2={20.7734}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00E6E6" />
                <stop offset={0.494792} stopColor="#0059B3" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint3_linear_16290_135"
                x1={23.6186}
                y1={41.7411}
                x2={50.0288}
                y2={17.4815}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#00BFFF" />
                <stop offset={1} stopColor="#80FFEA" />
            </linearGradient>
            <linearGradient
                id="f834d0da__paint4_linear_16290_135"
                x1={30.9291}
                y1={34.304}
                x2={35.9036}
                y2={29.1044}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E6FBFF" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <clipPath id="f834d0da__clip0_16290_135">
                <rect
                    width={27.2642}
                    height={27.2642}
                    rx={6}
                    transform="matrix(0.722843 -0.691609 0.722843 0.691609 -15.0967 51.0784)"
                    fill="white"
                />
            </clipPath>
            <clipPath id="f834d0da__clip1_16290_135">
                <rect
                    width={27.871}
                    height={26.6667}
                    fill="white"
                    transform="translate(22.0645 15.5557)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default SerpBudapestBadgeM;
