import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SubTicketsLight = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 171 158"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#ac7e2ce5__clip0_19167_4640)">
            <ellipse
                cx={80.3604}
                cy={82.8263}
                rx={79.1517}
                ry={62.9278}
                transform="rotate(25.0728 80.3604 82.8263)"
                fill="#ECF2F9"
            />
            <path
                d="M49.0789 34.8197C47.9026 34.9866 46.6608 34.6274 45.7093 33.7394C44.0537 32.1864 43.9047 29.6262 45.3663 27.9083L66.8796 2.48454C67.7938 1.3988 69.0727 0.768019 70.4855 0.682321C71.8905 0.607297 73.2442 1.09406 74.2839 2.07471C75.3222 3.046 75.9149 4.37688 75.9603 5.8141C76.0056 7.25132 75.4861 8.60614 74.497 9.62603L51.4372 33.6056C50.7756 34.2922 49.9427 34.6972 49.0789 34.8197ZM70.3179 2.59909C69.5276 2.71121 68.8154 3.10861 68.2942 3.72751L46.7808 29.1512C45.978 30.0969 46.0653 31.4995 46.9747 32.3552C47.8828 33.2016 49.2655 33.168 50.1236 32.2814L73.1833 8.30181C73.8122 7.64853 74.1476 6.77873 74.1206 5.86475C74.0935 4.95077 73.7094 4.09701 73.0487 3.47369C72.3789 2.85167 71.518 2.53401 70.616 2.58549C70.5017 2.57302 70.4098 2.58606 70.3179 2.59909Z"
                fill="#00E6C5"
            />
            <path
                d="M40.0684 45.6578C38.6717 45.8561 37.2066 45.4426 36.0815 44.3881C35.1196 43.4921 34.5614 42.2711 34.5032 40.9409C34.4464 39.62 34.894 38.3519 35.769 37.3864C36.6427 36.4115 37.8482 35.858 39.1337 35.7998C40.4297 35.7497 41.6769 36.2133 42.6296 37.1106C44.6087 38.9617 44.7471 42.1065 42.9421 44.1123C42.168 44.9965 41.1436 45.5052 40.0684 45.6578ZM38.9305 37.7312C38.2505 37.8277 37.6223 38.1559 37.1534 38.6813C36.6111 39.2841 36.337 40.0592 36.3691 40.8768C36.4103 41.6932 36.7521 42.4477 37.3469 43.0039C38.5694 44.1497 40.4707 44.0711 41.588 42.8322C42.7053 41.5932 42.6169 39.6555 41.4036 38.5083C40.8088 37.9522 40.0466 37.6684 39.2443 37.6962C39.1327 37.7025 39.0316 37.7168 38.9305 37.7312Z"
                fill="#00E6C5"
            />
            <path
                d="M13.0819 91.871C11.8571 89.0759 13.228 85.8285 16.0896 84.7626C26.8136 80.7679 45.4795 72.9605 73.0748 57.2143C80.141 53.1824 89.294 47.9894 93.4057 45.5245C98.5877 49.6669 104.924 44.6452 103.638 38.6739C114.744 31.0353 123.743 24.2759 128.384 20.6007C130.619 18.8304 133.869 19.258 135.577 21.5412L168.794 65.5352C170.368 67.6403 170.071 70.594 168.105 72.3394C163.242 76.6557 153.321 83.8174 140.806 93.3477C135.832 90.6576 131.105 95.0676 132.117 99.8062C124.697 105.188 112.878 111.975 104.245 117C75.69 133.62 55.6803 141.724 43.9015 146.071C41.2587 147.046 38.3198 145.793 37.19 143.214L13.0819 91.871Z"
                fill="#FFCC00"
            />
            <mask
                id="ac7e2ce5__mask0_19167_4640"
                style={{
                    maskType: 'alpha',
                }}
                maskUnits="userSpaceOnUse"
                x={12}
                y={19}
                width={158}
                height={128}
            >
                <path
                    d="M13.0799 91.872C11.8551 89.0768 13.226 85.8295 16.0876 84.7635C26.8117 80.7688 45.4776 72.9614 73.0729 57.2153C80.1391 53.1833 89.2921 47.9904 93.4037 45.5254C98.5857 49.6678 104.922 44.6462 103.636 38.6749C114.742 31.0363 123.741 24.2768 128.382 20.6017C130.617 18.8314 133.867 19.259 135.575 21.5422L168.792 65.5361C170.366 67.6413 170.069 70.5949 168.103 72.3404C163.24 76.6567 153.319 83.8184 140.804 93.3487C135.83 90.6585 131.103 95.0685 132.115 99.8072C124.695 105.189 112.876 111.976 104.243 117.001C75.688 133.621 55.6784 141.725 43.8996 146.072C41.2567 147.047 38.3178 145.794 37.1881 143.215L13.0799 91.872Z"
                    fill="#FFCC00"
                />
            </mask>
            <g mask="url(#ac7e2ce5__mask0_19167_4640)">
                <path
                    d="M1.68632 87.1389C2.37866 85.929 3.54331 84.9887 5.01283 84.6234C16.1197 81.8637 35.5483 76.2112 64.7464 63.6778C72.2228 60.4684 81.9041 56.3407 86.268 54.3555C90.9489 59.0558 97.8119 54.7807 97.2091 48.7024C109.107 42.3649 118.812 36.6638 123.838 33.5354C126.259 32.0286 129.441 32.8201 130.879 35.2813L149.899 67.4797C151.925 70.9087 150.604 75.3438 147.071 77.1892C140.96 80.382 131.84 85.3765 125.245 90C120.382 87.1163 115.484 91.337 116.309 96.1115C90.3508 112.516 59.8093 125.554 27.7015 135.988C25.0225 136.859 18.3788 130.394 17.3517 127.773L1.68632 87.1389Z"
                    fill="#DEB700"
                />
            </g>
            <path
                d="M1.56656 70.9997C0.690365 68.0754 2.44436 65.0167 5.4126 64.3049C16.5373 61.6373 36.0039 56.1457 65.2926 43.8523C72.7925 40.7045 82.5035 36.6566 86.882 34.707C91.5212 39.4486 98.9611 35.0839 97.8651 29.1438C109.81 22.9037 119.559 17.2815 124.608 14.194C127.041 12.7068 130.214 13.5256 131.631 15.9998L159.254 63.7139C160.561 65.9952 159.908 68.8923 157.745 70.3873C152.398 74.0846 141.686 79.9946 128.113 87.9424C123.504 84.6682 118.279 88.4749 118.709 93.3035C110.694 97.7488 98.1453 103.056 88.9696 107.001C58.6232 120.045 37.7872 125.669 25.5734 128.559C22.8329 129.207 20.0692 127.606 19.2608 124.909L1.56656 70.9997Z"
                fill="url(#ac7e2ce5__paint0_linear_19167_4640)"
            />
            <path
                d="M89.8889 57.6185L88.6461 54.7723C88.3304 54.0516 87.4905 53.7376 86.7828 54.0831C77.3188 58.7055 65.9197 63.3604 56.0693 66.8333C55.312 67.1005 54.9501 67.9463 55.271 68.6823L56.4966 71.4867C56.7814 72.1399 57.5119 72.4735 58.1886 72.2537C69.2152 68.6658 80.9315 64.0039 89.3045 59.3788C89.9279 59.0344 90.1737 58.2718 89.8889 57.6185ZM95.0901 69.1628L93.8472 66.3166C93.5315 65.5959 92.6916 65.2819 91.9839 65.6274C82.5204 70.2485 71.1213 74.9033 61.2705 78.3776C60.5131 78.6447 60.1512 79.4906 60.4721 80.2266L61.6977 83.031C61.9825 83.6842 62.7142 84.0182 63.3908 83.7984C74.4174 80.2104 86.1327 75.5482 94.5057 70.9231C95.1295 70.5773 95.374 69.8143 95.0901 69.1628ZM80.3082 84.3123C75.557 86.3224 70.7974 88.2039 66.3521 89.8376C65.5987 90.1151 65.2466 90.9658 65.5784 91.6965L66.841 94.485C67.1348 95.1339 67.8691 95.4583 68.5445 95.2291C73.2634 93.6244 78.1061 91.8178 82.7551 89.9046C83.4782 89.6062 83.8053 88.7665 83.4823 88.0537L82.1048 85.0116C81.7973 84.3282 80.9993 84.0195 80.3082 84.3123Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M27.9374 72.7994C27.0103 73.1118 26.3981 73.9955 26.4312 74.9736L26.4663 76.0122C24.6463 76.8805 22.8653 77.8645 21.1234 78.9643C19.6828 79.8738 19.0519 81.6515 19.5964 83.2666L24.6122 98.3065C25.655 101.399 28.8308 102.478 32.0987 102.021C32.0987 102.021 37.4642 100.929 40.814 99.9081C44.1179 98.9006 49.1122 96.8477 49.1122 96.8477C52.3806 95.4845 53.8652 92.4542 52.8223 89.3612L46.8951 74.5462C46.3506 72.931 44.7719 71.8978 43.0745 72.0455C42.642 72.0832 42.1945 72.1181 41.7391 72.1537C40.0327 72.287 38.2143 72.4291 36.6558 72.7529L36.0549 71.9049C35.489 71.1063 34.4666 70.7733 33.5395 71.0857L27.9374 72.7994ZM37.1049 88.856C34.0482 89.8751 29.0213 91.145 29.0213 91.145C27.8736 91.5316 26.6885 91.2218 26.185 90.2294L23.0888 84.3139C22.5663 83.284 22.9988 82.0104 24.0836 81.3848C27.004 79.7006 30.0303 78.3308 33.1626 77.2755C36.2949 76.2202 39.0588 75.8118 42.4031 75.3852C43.6454 75.2268 44.7609 75.9788 44.9686 77.1148L46.235 83.5393C46.4351 84.6339 45.6794 85.5977 44.5317 85.9843C44.5317 85.9843 40.1074 87.8551 37.1049 88.856ZM33.8908 98.8566C35.2821 98.3879 36.0296 96.8796 35.5603 95.4877C35.0911 94.0959 33.5828 93.3476 32.1914 93.8163C30.8001 94.2851 30.0526 95.7934 30.5219 97.1852C30.9911 98.5771 32.4994 99.3254 33.8908 98.8566ZM47.2222 91.8184C47.6794 93.1746 46.9222 94.654 45.5308 95.1228C44.1395 95.5915 42.6409 94.8721 42.1837 93.5159C41.7265 92.1598 42.4837 90.6804 43.875 90.2116C45.2664 89.7428 46.7649 90.4622 47.2222 91.8184Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M34.6616 104.512C34.6616 104.512 39.732 103.26 41.722 102.589C46.5116 100.975 48.8056 100.189 48.8056 100.189L51.7515 101.527C51.988 101.579 52.1649 101.841 52.1465 102.111C52.1339 102.296 52.0307 102.446 51.8799 102.496C51.8799 102.496 49.9372 103.267 43.1595 105.551C38.4486 107.139 33.3328 108.397 33.3328 108.397C33.113 108.471 32.8624 108.316 32.773 108.051C32.7118 107.869 32.7409 107.674 32.8484 107.548L34.6616 104.512Z"
                fill="white"
            />
            <path
                d="M98.9905 40.2366C99.4684 41.1828 99.0885 42.3369 98.1419 42.8144C97.1952 43.2921 96.0403 42.9123 95.5624 41.9661C95.0843 41.0201 95.4642 39.866 96.4109 39.3883C97.3575 38.9108 98.5124 39.2906 98.9905 40.2366Z"
                fill="#891712"
            />
            <path
                d="M103.03 48.2306C103.508 49.1768 103.128 50.3308 102.181 50.8082C101.235 51.2858 100.08 50.9059 99.6016 49.9597C99.1236 49.0137 99.5034 47.8597 100.45 47.3821C101.397 46.9047 102.552 47.2845 103.03 48.2306Z"
                fill="#891712"
            />
            <path
                d="M107.069 56.2227C107.547 57.169 107.167 58.323 106.22 58.8004C105.274 59.278 104.119 58.8982 103.641 57.9519C103.163 57.0059 103.543 55.8519 104.489 55.3743C105.436 54.8969 106.591 55.2767 107.069 56.2227Z"
                fill="#891712"
            />
            <path
                d="M111.108 64.215C111.586 65.161 111.206 66.3153 110.26 66.7927C109.313 67.2703 108.158 66.8904 107.68 65.9442C107.202 64.9982 107.581 63.8442 108.528 63.3665C109.475 62.8889 110.63 63.269 111.108 64.215Z"
                fill="#891712"
            />
            <path
                d="M115.147 72.2087C115.625 73.1547 115.245 74.3087 114.299 74.7863C113.352 75.2639 112.197 74.8839 111.719 73.9379C111.241 72.9918 111.621 71.8376 112.567 71.3602C113.514 70.8826 114.669 71.2624 115.147 72.2087Z"
                fill="#891712"
            />
            <path
                d="M119.186 80.2009C119.664 81.1469 119.284 82.3009 118.338 82.7785C117.391 83.2559 116.236 82.8761 115.758 81.93C115.28 80.9838 115.66 79.8298 116.606 79.3524C117.553 78.8748 118.708 79.2547 119.186 80.2009Z"
                fill="#891712"
            />
            <rect
                x={107.583}
                y={120.136}
                width={32.8743}
                height={26.9667}
                rx={3.85714}
                transform="rotate(20.6144 107.583 120.136)"
                stroke="#00E6C5"
                strokeWidth={2.57143}
                strokeLinejoin="round"
            />
            <line
                x1={115.534}
                y1={119.971}
                x2={113.839}
                y2={124.475}
                stroke="#00E6C5"
                strokeWidth={2.57143}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <line
                x1={123.827}
                y1={123.091}
                x2={122.132}
                y2={127.596}
                stroke="#00E6C5"
                strokeWidth={2.57143}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <line
                x1={132.122}
                y1={126.21}
                x2={130.427}
                y2={130.715}
                stroke="#00E6C5"
                strokeWidth={2.57143}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <rect
                x={110.104}
                y={130.756}
                width={2.95381}
                height={2.95381}
                rx={1.47691}
                transform="rotate(20.6144 110.104 130.756)"
                fill="#00E6C5"
            />
            <rect
                x={107.504}
                y={137.667}
                width={2.95381}
                height={2.95381}
                rx={1.47691}
                transform="rotate(20.6144 107.504 137.667)"
                fill="#00E6C5"
            />
            <rect
                x={118.396}
                y={133.876}
                width={2.95381}
                height={2.95381}
                rx={1.47691}
                transform="rotate(20.6144 118.396 133.876)"
                fill="#00E6C5"
            />
            <rect
                x={126.691}
                y={136.996}
                width={2.95381}
                height={2.95381}
                rx={1.47691}
                transform="rotate(20.6144 126.691 136.996)"
                fill="#00E6C5"
            />
            <rect
                x={115.797}
                y={140.788}
                width={2.95381}
                height={2.95381}
                rx={1.47691}
                transform="rotate(20.6144 115.797 140.788)"
                fill="#00E6C5"
            />
        </g>
        <defs>
            <linearGradient
                id="ac7e2ce5__paint0_linear_19167_4640"
                x1={22.2516}
                y1={129.797}
                x2={147.521}
                y2={37.6927}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C82125" />
                <stop offset={1} stopColor="#E84727" />
            </linearGradient>
            <clipPath id="ac7e2ce5__clip0_19167_4640">
                <rect width={171} height={158} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default SubTicketsLight;
