import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TouchLogoTravelSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 23 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect
            width={21.986}
            height={21.986}
            rx={10.993}
            transform="matrix(1 -8.74228e-08 -8.74228e-08 -1 0.922852 22.6958)"
            fill="#FFCC00"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.6717 5.99095H14.6943L16.0943 1.53174C16.3852 1.65139 16.6699 1.78317 16.9477 1.92644L15.6717 5.99095Z"
            fill="#292929"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.3308 0.975917C14.0274 0.907892 13.7192 0.852415 13.4068 0.810059L11.7422 5.99063H12.7195L14.3308 0.975917Z"
            fill="#292929"
        />
        <path
            d="M7.32127 15.1517C7.04781 15.0707 6.7541 15.0707 6.47558 15.1467C5.98943 15.2581 5.62988 15.8962 5.62988 16.8229C5.62988 17.7496 5.91853 18.2509 6.30341 18.4737C6.59712 18.5699 6.91109 18.5801 7.20986 18.494C7.54915 18.4079 8.05555 17.7445 8.05555 16.8178C8.05555 15.8911 7.78209 15.2885 7.32127 15.1517Z"
            fill="#292929"
        />
        <path
            d="M16.3602 15.1517C16.0918 15.0707 15.8032 15.0707 15.5297 15.1467C15.0537 15.2581 14.6992 15.8962 14.6992 16.8229C14.6992 17.7496 14.9828 18.2509 15.3626 18.4737C15.6512 18.5699 15.9601 18.5801 16.2539 18.494C16.5881 18.4079 17.0844 17.7445 17.0844 16.8178C17.0844 15.8911 16.8109 15.2885 16.3602 15.1517Z"
            fill="#292929"
        />
        <path
            d="M16.3502 5.44385C16.3553 5.44385 10.0405 5.44385 10.0405 5.44385C8.52638 5.44385 7.99973 7.14026 7.99973 7.14026C7.99973 7.14026 6.19694 12.9841 5.53356 15.1161C4.87018 17.248 7.20468 18.0886 7.79717 18.0886C8.61247 18.0886 14.3753 18.0886 14.3905 18.0886C14.9931 18.0886 15.383 17.643 15.383 16.7416C15.383 15.6832 15.9451 15.1515 16.3401 15.1667C16.4768 15.192 16.6034 15.2629 16.6895 15.3693C17.2769 13.45 18.7506 8.77086 18.8063 8.54805C19.5 6.56803 17.4491 5.44385 16.3502 5.44385Z"
            fill="url(#bd7afd73__paint0_linear_16347_129)"
        />
        <path
            d="M16.9833 6.05676C16.796 6.04664 16.6289 6.16311 16.5732 6.34541L13.95 14.3819C13.95 14.387 13.945 14.3921 13.945 14.4022C13.8842 14.6858 13.7778 14.9592 13.631 15.2074C13.4639 15.3897 13.5348 15.7087 14.3248 15.5213C15.1147 15.334 15.1958 14.8478 15.5401 13.7996C15.8389 12.8881 17.2619 8.40645 17.6315 7.24174C17.7227 6.97841 17.6974 6.68976 17.5657 6.44163C17.4543 6.21375 17.2315 6.07196 16.9833 6.05676Z"
            fill="url(#bd7afd73__paint1_linear_16347_129)"
        />
        <path
            d="M13.8537 7.18627C13.6967 7.561 11.6761 14.0227 11.5698 14.3569C11.4635 14.6911 11.9192 14.7975 11.9192 14.7975L14.4208 6.83179L14.4259 6.81664H14.4107C14.1626 6.79132 13.9296 6.94826 13.8537 7.18627Z"
            fill="url(#bd7afd73__paint2_linear_16347_129)"
        />
        <path
            d="M12.2994 6.81641C12.1272 6.85185 11.8842 6.81134 11.7272 7.18608C11.5702 7.56081 9.54968 14.0225 9.44333 14.3567C9.33699 14.6909 9.79275 14.7972 9.79275 14.7972L12.2994 6.81641Z"
            fill="url(#bd7afd73__paint3_linear_16347_129)"
        />
        <path
            d="M10.0812 6.81622C9.82795 6.7909 9.58995 6.94282 9.50892 7.18589C9.35194 7.56063 7.33141 14.0223 7.22507 14.3565C7.11873 14.6907 7.57448 14.7971 7.57448 14.7971L10.0812 6.81622Z"
            fill="url(#bd7afd73__paint4_linear_16347_129)"
        />
        <defs>
            <linearGradient
                id="bd7afd73__paint0_linear_16347_129"
                x1={12.181}
                y1={17.996}
                x2={12.181}
                y2={5.35324}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0852} stopColor="#C70100" />
                <stop offset={0.1948} stopColor="#E11C1B" />
                <stop offset={0.979} stopColor="#E11C1B" />
            </linearGradient>
            <linearGradient
                id="bd7afd73__paint1_linear_16347_129"
                x1={14.1928}
                y1={15.692}
                x2={17.143}
                y2={6.08343}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E52F2D" />
                <stop offset={0.07468} stopColor="#E63634" />
                <stop offset={1} stopColor="#EF8883" />
            </linearGradient>
            <linearGradient
                id="bd7afd73__paint2_linear_16347_129"
                x1={11.7544}
                y1={14.6122}
                x2={14.92}
                y2={4.36432}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="bd7afd73__paint3_linear_16347_129"
                x1={9.81098}
                y1={14.0115}
                x2={12.9766}
                y2={3.76366}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="bd7afd73__paint4_linear_16347_129"
                x1={7.78882}
                y1={13.3867}
                x2={10.9545}
                y2={3.13889}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
        </defs>
    </svg>
);

export default TouchLogoTravelSign;
