import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TouchLogoYaSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 23 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <mask
            id="89be4532__mask0_16347_128"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={23}
            height={23}
        >
            <ellipse
                cx={11.015}
                cy={11.7283}
                rx={11.015}
                ry={11.015}
                fill="white"
            />
        </mask>
        <g mask="url(#89be4532__mask0_16347_128)">
            <rect
                width={22.0299}
                height={22.0299}
                transform="translate(0 0.713379)"
                fill="#FC3F1D"
            />
            <path
                d="M12.6392 6.88215H11.5244C9.61342 6.88215 8.6579 7.83766 8.6579 9.27093C8.6579 10.8635 9.29491 11.6597 10.7282 12.6152L11.8429 13.4115L8.6579 18.3483H6.10986L9.13566 13.8893C7.38388 12.6152 6.42837 11.5005 6.42837 9.43019C6.42837 6.88215 8.18014 5.13037 11.5244 5.13037H14.8687V18.3483H12.6392V6.88215Z"
                fill="white"
            />
        </g>
    </svg>
);

export default TouchLogoYaSign;
