import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TelegramIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 32 32" fill="none" focusable={false} {...props}>
        <path
            d="M25.9048 0H6.09524C2.72893 0 0 2.72893 0 6.09524V25.9048C0 29.2711 2.72893 32 6.09524 32H25.9048C29.2711 32 32 29.2711 32 25.9048V6.09524C32 2.72893 29.2711 0 25.9048 0Z"
            fill="#2CA5E0"
        />
        <path
            d="M7.30793 15.4456L17.9702 11.0525C19.0227 10.5949 22.5922 9.13065 22.5922 9.13065C22.5922 9.13065 24.2396 8.49006 24.1023 10.0458C24.0565 10.6864 23.6906 12.9287 23.3243 15.3539L22.1804 22.5381C22.1804 22.5381 22.0888 23.5906 21.3096 23.7736C20.5303 23.9567 19.2503 23.1331 19.0217 22.9499C18.8387 22.8127 15.5896 20.7535 14.3997 19.7468C14.0794 19.4723 13.7134 18.923 14.4455 18.2825C16.0929 16.7724 18.0607 14.8961 19.2503 13.7064C19.7995 13.1573 20.3486 11.876 18.0606 13.432L11.6083 17.7792C11.6083 17.7792 10.8761 18.2368 9.50332 17.825C8.13059 17.4132 6.52894 16.8641 6.52894 16.8641C6.52894 16.8641 5.43065 16.1777 7.30687 15.4457L7.30793 15.4456Z"
            fill="white"
        />
    </svg>
);

TelegramIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default TelegramIcon;
