import '@yandex-int/error-counter/dist/interfaceWithoutRum.min';
import '@yandex-int/error-counter/dist/implementation.min';
import '@yandex-int/error-counter/dist/filters.min';
import '@yandex-int/error-counter/dist/sendWithoutRum.min';
import '@yandex-int/error-counter/dist/logError.min';
import '@yandex-int/error-counter/dist/logAjaxError.min';
import '@yandex-int/error-counter/dist/logEvent.min';
import {deserializeError} from 'serialize-error';

import {IPostMessage} from 'types/postMessage/IPostMessage';
import {EPostMessageType} from 'types/postMessage/EPostMessageType';
import {IErrorCounterSettings} from 'types/rum/IErrorCounterSettings';

export default class ErrorBoosterProvider {
    settings: IErrorCounterSettings = {
        project: 'travel',
        page: 'index',
        platform: 'ontouchstart' in window ? 'touch' : 'desktop',
        version: __BUILD_VERSION__,
        unhandledRejection: true,
        env: __ENV__,
        debug: false,
        filter: {},
        experiments: [],
        transform: error => ({
            ...error,
            service: 'front.widgets',
        }),
    };

    constructor() {
        this.init();
    }

    private init(): void {
        document.addEventListener('DOMContentLoaded', () => {
            window.Ya.Rum.initErrors(this.settings);

            window.addEventListener(
                'message',
                this.handleMessage.bind(this),
                false,
            );

            window.parent.postMessage(
                JSON.stringify({
                    type: EPostMessageType.ERROR_LOGGER_INITED,
                }),
            );
        });
    }

    private parseMessage(message?: string): IPostMessage | undefined {
        if (!message) {
            return;
        }

        try {
            return JSON.parse(message);
        } catch (err) {}
    }

    private handleMessage(message: MessageEvent): void {
        const parsedMessage = this.parseMessage(message.data);

        if (parsedMessage?.type !== EPostMessageType.LOG_ERROR) {
            return;
        }

        window.Ya.Rum.logError(
            parsedMessage.data.params,
            deserializeError(parsedMessage.data.error),
        );
    }
}
