import {IMetrika} from 'types/metrika/IMetrika';
import {IPostMessage} from 'types/postMessage/IPostMessage';
import {EPostMessageType} from 'types/postMessage/EPostMessageType';

export default class MetrikaProvider {
    // @ts-ignore
    // eslint-disable-next-line new-cap
    counter: IMetrika = new window.Ya.Metrika2({
        id: 88700444,
        clickmap: true,
        trackLinks: true,
        accurateTrackBounce: true,
    });

    constructor() {
        this.init();
    }

    private init(): void {
        window.addEventListener(
            'message',
            this.handleMessage.bind(this),
            false,
        );

        window.parent.postMessage(
            JSON.stringify({
                type: EPostMessageType.METRIKA_INITED,
            }),
        );
    }

    private parseMessage(message?: string): IPostMessage | undefined {
        if (!message) {
            return;
        }

        try {
            return JSON.parse(message);
        } catch (err) {}
    }

    private handleMessage(message: MessageEvent): void {
        const parsedMessage = this.parseMessage(message.data);

        if (!parsedMessage) {
            return;
        }

        switch (parsedMessage.type) {
            case EPostMessageType.METRIKA_REACHED_GOAL:
                this.counter.reachGoal(
                    parsedMessage.data.target,
                    parsedMessage.data.params,
                );

                break;

            case EPostMessageType.METRIKA_SENDED_PARAMS:
                this.counter.params(parsedMessage.data.params);

                break;
        }
    }
}
