import {ECalendarType} from 'components/Calendar/types';

export interface ICalendarPricesByType {
    [ECalendarType.START_DATE]?: TCalendarPrices;
    [ECalendarType.END_DATE]?: TCalendarPrices;
}

export type TCalendarPrices = Record<
    string,
    ICalendarPrice | ICalendarEmptyPrice
>;

export interface ICalendarPrice {
    currency: string;
    value: number;
    roughly: boolean;
    isLow?: boolean;
}

export interface ICalendarEmptyPrice {
    emptyPriceReason?: ECalendarEmptyPriceReason;
}

export enum ECalendarEmptyPriceReason {
    SOLD_OUT = 'SOLD_OUT',
    NO_DIRECT_TRAINS = 'NO_DIRECT_TRAINS',
    OTHER = 'OTHER',
}
