import {ERumErrorLevel} from 'types/rum/ERumErrorLevel';
import {IRumErrorOptions} from 'types/rum/IRumErrorOptions';

export interface IErrorBooster {
    log(
        level: ERumErrorLevel,
        options: Omit<IRumErrorOptions, 'level' | 'service'>,
        error?: Error | unknown,
    ): void;

    error(
        options: Omit<IRumErrorOptions, 'level' | 'service'>,
        error?: Error | unknown,
    ): void;

    warn(
        options: Omit<IRumErrorOptions, 'level' | 'service'>,
        error?: Error | unknown,
    ): void;
}
