import {IHotelIdentifier} from 'types/hotels/hotel/IHotel';
import {TGeoId} from 'types/hotels/hotel/IGeoRegion';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';

export enum ESearchSuggestItemType {
    REGION = 'region',
    HOTEL = 'hotel',
    HOTELS_NEARBY = 'hotels_nearby',
    HISTORY = 'history',
    CROSS_SALE = 'cross_sale',
    CROSS_SEARCH = 'cross_search',
}

export interface ISearchSuggestRedirectParams extends IHotelIdentifier {
    type: ESearchSuggestItemType;
    geoId?: TGeoId;
    selectedSortId?: string;
    sortOrigin?: string;
    offerSearchParams?: IRequiredOfferParams;
}

/* Group items */

export type TSuggestGroups = ISuggestGroup[];

export interface IBaseSuggestItem {
    id: string;
    name: string;
    description?: string;
    redirectParams: ISearchSuggestRedirectParams;
}

export interface ISuggestGroup {
    name: string;
    items: IBaseSuggestItem[];
}

/* Flat items */

export interface IHotelsSuggest extends IBaseSuggestItem {
    groupName: string;
    type?: ESearchSuggestItemType;
}
