import {IRumErrorOptions} from 'types/rum/IRumErrorOptions';

interface IYandexErrorFilter {
    [key: string]: string;
}

/** https://a.yandex-team.ru/arcadia/frontend/packages/rum-counter */
export interface IErrorCounterSettings {
    version: string;
    project: string;
    page: string;
    env?: string;
    unhandledRejection: boolean;
    traceUnhandledRejection?: boolean;
    platform: string;
    debug: boolean;
    region?: number;
    filter: {
        stack?: IYandexErrorFilter;
        message?: IYandexErrorFilter;
        url?: IYandexErrorFilter;
    };
    experiments: string[];
    transform?(error: IRumErrorOptions): IRumErrorOptions;
}
