import {ERumErrorLevel} from 'types/rum/ERumErrorLevel';

export interface IRumErrorOptions {
    message: string; // Текст ошибки
    block?: string; // Блок, в котором произошла ошибка
    method?: string; // Метод, в котором произошла ошибка
    source?: string; // Источник ошибки
    sourceMethod?: string; // Метод источника ошибки
    type?: string; // Тип ошибки, например: network, logic
    page?: string; // Страница сервиса, например: index, search, product
    service?: string; // Если на одной странице живет несколько сервисов, например: Эфир, Дзен на морде
    level: ERumErrorLevel; // !! Доступные значения: info, debug, warn, error, fatal
    additional?: Record<string, string | number | boolean>; // key-value дополнительной информации, без вложенности. Не нужно передавать сюда state приложения
}
