import {IPostMessage} from 'types/postMessage/IPostMessage';
import {EPostMessageType} from 'types/postMessage/EPostMessageType';

export default class Chanel {
    private chanel: MessageEventSource | null = null;
    private queue: string[] = [];
    private waitFor: EPostMessageType;

    constructor(waitFor: EPostMessageType) {
        this.waitFor = waitFor;
        this.init();
    }

    protected sendOrQueue(message: string): void {
        if (this.chanel) {
            this.chanel.postMessage(message);
        } else {
            this.queue.push(message);
        }
    }

    private init(): void {
        window.addEventListener(
            'message',
            this.handleMessage.bind(this),
            false,
        );
    }

    private parseMessage(message?: string): IPostMessage | undefined {
        if (!message) {
            return;
        }

        try {
            return JSON.parse(message);
        } catch (err) {}
    }

    private handleMessage(event: MessageEvent): void {
        if (this.parseMessage(event.data)?.type === this.waitFor) {
            this.chanel = event.source;
            this.handleQueue();
        }
    }

    private handleQueue(): void {
        if (!this.chanel || !this.queue.length) {
            return;
        }

        for (let i = 0; i < this.queue.length; i++) {
            this.chanel.postMessage(this.queue[i]);
        }

        this.queue = [];
    }
}
