import {HUMAN} from 'constants/dateFormats';

import {EWhenSpecialValues} from 'types/common/When';

import {formatDate, humanFormatDate} from 'utilities/dateUtils';
import isSpecialWhen from 'utilities/dateUtils/when/isSpecialWhen';
import getSpecialWhen from 'utilities/dateUtils/when/getSpecialWhen';
import getWhenSpecialValueText from 'utilities/dateUtils/when/getWhenSpecialValueText';

export default function getHumanWhen(
    when: string | EWhenSpecialValues,
    options?: {
        withPossibleYear?: boolean;
        timezone?: string;
    },
): string {
    const formattedWhen =
        (options?.timezone ? getSpecialWhen(when, options.timezone) : when) ||
        when;

    if (isSpecialWhen(formattedWhen)) {
        return getWhenSpecialValueText(formattedWhen).toLowerCase();
    }

    const withPossibleYear = options?.withPossibleYear;

    if (withPossibleYear) {
        return humanFormatDate(formattedWhen);
    }

    return formatDate(formattedWhen, HUMAN, {withNbsp: true});
}
