import moment from 'moment-timezone';

import {EWhenSpecialValues} from 'types/common/When';

import {getNow} from 'utilities/dateUtils';

export default function getSpecialWhen(
    when: string,
    timezone: string,
): EWhenSpecialValues | null {
    const whenMoment = moment.tz(when, timezone);
    const nowMoment = moment(getNow()).tz(timezone);

    if (nowMoment.isSame(whenMoment, 'day')) {
        return EWhenSpecialValues.TODAY;
    }

    if (nowMoment.add(1, 'day').isSame(whenMoment, 'day')) {
        return EWhenSpecialValues.TOMORROW;
    }

    if (nowMoment.add(2, 'day').isSame(whenMoment, 'day')) {
        return EWhenSpecialValues.AFTER_TOMORROW;
    }

    if (nowMoment.add(1, 'week').isSame(whenMoment, 'day')) {
        return EWhenSpecialValues.NEXT_WEEK;
    }

    if (nowMoment.add(1, 'month').isSame(whenMoment, 'day')) {
        return EWhenSpecialValues.NEXT_MONTH;
    }

    return null;
}
