import moment, {Moment} from 'moment-timezone';

import {EWhenSpecialValues} from 'types/common/When';

import {getNow} from 'utilities/dateUtils';

export default function getWhenMomentFromSpecialWhen(
    when: EWhenSpecialValues,
    timezone?: string,
): Moment {
    const nowMoment = timezone
        ? moment(getNow()).tz(timezone)
        : moment(getNow());

    if (when === EWhenSpecialValues.TODAY) {
        return nowMoment;
    }

    if (when === EWhenSpecialValues.TOMORROW) {
        return nowMoment.add(1, 'days');
    }

    if (when === EWhenSpecialValues.AFTER_TOMORROW) {
        return nowMoment.add(2, 'days');
    }

    if (when === EWhenSpecialValues.NEXT_WEEK) {
        return nowMoment.add(1, 'week');
    }

    if (when === EWhenSpecialValues.NEXT_MONTH) {
        return nowMoment.add(1, 'month');
    }

    return nowMoment;
}
