import {EWhenSpecialValues} from 'types/common/When';

import * as i18nBlock from 'i18n/when-special-values';

export default function getWhenSpecialValueText(
    specialWhen: EWhenSpecialValues,
): string {
    switch (specialWhen) {
        case EWhenSpecialValues.TODAY:
            return i18nBlock.today();
        case EWhenSpecialValues.TOMORROW:
            return i18nBlock.tomorrow();
        case EWhenSpecialValues.AFTER_TOMORROW:
            return i18nBlock.afterDashTomorrow();
        case EWhenSpecialValues.NEXT_WEEK:
        case EWhenSpecialValues.NEXT_MONTH:
            return '';
    }
}
