import {IDeviceOS} from 'types/IDeviceOS';

/*
 * Функция определения оси и её версии
 * @param os - данные ОС
 * @param name - имя ОС для сравнения
 * @param version - мажорный номер ОС для сравнения
 */
export function isOS(os: IDeviceOS, name: string, version?: number): boolean {
    return (
        os.name === name &&
        (version ? parseInt(os.version, 10) === version : true)
    );
}
