import {publishSync} from 'pubsub-js';

import {EPubSubEvent} from 'types/EPubSubEvent';

/**
 * Кроссбраузерная прокрутка скролла в элементе до указанных координат.
 * Если element не указан, то будет прокрутка скролла для всего документа.
 */
export default function scrollTo(
    options: ScrollToOptions,
    element?: HTMLElement,
): void {
    const supportsNativeSmoothScroll =
        'scrollBehavior' in document.documentElement.style;

    publishSync(EPubSubEvent.SCROLL_CHANGED, options);

    if (element) {
        if (supportsNativeSmoothScroll) {
            element.scrollTo(options);
        } else {
            if (typeof options.top !== 'undefined') {
                element.scrollTop = options.top;
            }

            if (typeof options.left !== 'undefined') {
                element.scrollLeft = options.left;
            }
        }
    } else if (supportsNativeSmoothScroll) {
        window.scrollTo(options);
    } else {
        if (typeof options.top !== 'undefined') {
            document.body.scrollTop = options.top; // For Safari
            document.documentElement.scrollTop = options.top; // For Chrome, Firefox, IE and Opera
        }

        if (typeof options.left !== 'undefined') {
            document.body.scrollLeft = options.left; // For Safari
            document.documentElement.scrollLeft = options.left; // For Chrome, Firefox, IE and Opera
        }
    }
}
