import {serializeError} from 'serialize-error';

import {ERumErrorLevel} from 'types/rum/ERumErrorLevel';
import {IRumErrorOptions} from 'types/rum/IRumErrorOptions';
import {IErrorBooster} from 'types/errorBooster/IErrorBooster';
import {EPostMessageType} from 'types/postMessage/EPostMessageType';

import Chanel from 'utilities/chanel/chanel';

export default class ErrorBooster extends Chanel implements IErrorBooster {
    constructor() {
        super(EPostMessageType.ERROR_LOGGER_INITED);
    }

    log(
        level: ERumErrorLevel,
        options: Omit<IRumErrorOptions, 'level' | 'service'>,
        error?: Error | unknown,
    ): void {
        this.sendOrQueue(
            JSON.stringify({
                type: EPostMessageType.LOG_ERROR,
                data: {
                    params: {
                        ...options,
                        service: 'front.widgets',
                        level,
                    },
                    error: serializeError(error),
                },
            }),
        );
    }

    error(
        options: Omit<IRumErrorOptions, 'level' | 'service'>,
        error?: Error | unknown,
    ): void {
        this.log(ERumErrorLevel.ERROR, options, error);
    }

    warn(
        options: Omit<IRumErrorOptions, 'level' | 'service'>,
        error?: Error | unknown,
    ): void {
        this.log(ERumErrorLevel.WARN, options, error);
    }
}
