import {useState, useEffect, useCallback} from 'react';

export function measureHeight(): number | null {
    if (typeof window !== 'undefined') {
        return window.innerHeight || document.documentElement?.clientHeight;
    }

    return null;
}

export function use100vh(): number | null {
    const [height, setHeight] = useState<number | null>(measureHeight);

    const handleResize = useCallback(() => {
        setHeight(measureHeight());
    }, []);

    useEffect(() => {
        window.addEventListener('resize', handleResize);

        return (): void => window.removeEventListener('resize', handleResize);
    }, [handleResize]);

    return height;
}
