import {useMemo} from 'react';

import {AFFILIATE_QUERY_PARAMS_MAP} from 'constants/affiliate/affiliateQueryParamsMap';

import {AFFILIATE_FIELDS} from 'types/affiliate/EAffiliateField';
import {IAffiliateQueryParams} from 'types/affiliate/IAffiliateQueryParams';

import {useAffiliate} from 'hooks/useAffiliate';

export function useAffiliateParams(): IAffiliateQueryParams {
    const affiliate = useAffiliate();

    return useMemo(
        () =>
            AFFILIATE_FIELDS.reduce<IAffiliateQueryParams>((res, key) => {
                if (affiliate?.[key]) {
                    res[AFFILIATE_QUERY_PARAMS_MAP[key]] = affiliate[key];
                }

                return res;
            }, {}),
        [affiliate],
    );
}
