import {useEffect} from 'react';

import {EPubSubEvent} from 'types/EPubSubEvent';

import {subscribe, TPubSubSubscriber} from 'utilities/pubSub';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

export function usePubSubSubscriber<Event extends EPubSubEvent>(
    event: Event,
    subscriber: TPubSubSubscriber<Event>,
): void {
    const callback = useImmutableCallback(subscriber);

    useEffect(() => {
        return subscribe(event, callback);
    }, [callback, event]);
}
