import {useCallback, useState} from 'react';

import {tupple} from 'utilities/typle';

export function useToggle(init: boolean): [boolean, () => void] {
    const [value, setValue] = useState(init);

    const toggle = useCallback(() => {
        setValue(!value);
    }, [value]);

    return tupple(value, toggle);
}
