import {EMetrikaGoal} from 'types/metrika/EMetrikaGoal';
import {IMetrika, IMetrikaParams} from 'types/metrika/IMetrika';
import {EPostMessageType} from 'types/postMessage/EPostMessageType';

import Chanel from 'utilities/chanel/chanel';

export default class Metrika extends Chanel implements IMetrika {
    constructor() {
        super(EPostMessageType.METRIKA_INITED);
    }

    reachGoal(target: EMetrikaGoal, ...params: IMetrikaParams[]): void {
        this.sendOrQueue(
            JSON.stringify({
                type: EPostMessageType.METRIKA_REACHED_GOAL,
                data: {
                    target,
                    params,
                },
            }),
        );
    }

    params(...params: IMetrikaParams[]): void {
        this.sendOrQueue(
            JSON.stringify({
                type: EPostMessageType.METRIKA_REACHED_GOAL,
                data: {
                    params,
                },
            }),
        );
    }
}
