import {EWidgetType} from 'types/widgets/EWidgetType';
import {EMetrikaGoal} from 'types/metrika/EMetrikaGoal';
import {IMetrika, IMetrikaParams} from 'types/metrika/IMetrika';
import {IAffiliateParams} from 'types/affiliate/IAffiliateParams';

interface IWidgetMetrikaOptions {
    type: EWidgetType;
    affiliate: IAffiliateParams;
}

export class WidgetMetrika implements IMetrika {
    metrika: IMetrika;
    options: IWidgetMetrikaOptions;

    constructor(instance: IMetrika, options: IWidgetMetrikaOptions) {
        this.metrika = instance;
        this.options = options;
    }

    reachGoal(goal: EMetrikaGoal, ...params: IMetrikaParams[]): void {
        this.metrika.reachGoal(goal, this.buildParams(params));
    }

    params(...params: IMetrikaParams[]): void {
        this.metrika.params(this.buildParams(params));
    }

    private buildParams(params: IMetrikaParams[]): IMetrikaParams[] {
        return [
            ...params,
            {
                widget_type: this.options.type,
                partners_params: this.options.affiliate,
                site_url: {
                    [window.location.hostname]: {
                        [window.location.pathname]: window.location.search,
                    },
                },
            },
        ];
    }
}
