import {
    publish as pubSubPublish,
    publishSync as pubSubPublishSync,
    subscribe as pubSubSubscribe,
    unsubscribe as pubSubUnsubscribe,
} from 'pubsub-js';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {EPubSubEvent} from 'types/EPubSubEvent';

export interface IPubSubEventData {
    [EPubSubEvent.SCHEME_MOUSE_MOVE]: unknown;
    [EPubSubEvent.SCHEME_PLACE_ENTER]: unknown;
    [EPubSubEvent.SCHEME_PLACE_LEAVE]: unknown;
    [EPubSubEvent.SCHEME_CLOSE_ALL]: unknown;
    [EPubSubEvent.SCROLL_CHANGED]: ScrollToOptions;
    [EPubSubEvent.FOCUS_SEARCH_FORM_FIELD]: ESearchFormFieldName;
}

type TEventArgs<Event extends EPubSubEvent> =
    Event extends keyof IPubSubEventData ? [IPubSubEventData[Event]] : [];

export type TPubSubSubscriber<Event extends EPubSubEvent> = (
    ...args: TEventArgs<Event>
) => void;

export function subscribe<Event extends EPubSubEvent>(
    event: Event,
    callback: TPubSubSubscriber<Event>,
): () => void {
    const subscription = pubSubSubscribe(
        event,
        (_event: string, ...args: TEventArgs<Event>) => {
            callback(...args);
        },
    );

    return (): void => {
        pubSubUnsubscribe(subscription);
    };
}

export function subscribeOnce<Event extends EPubSubEvent>(
    event: Event,
    callback: TPubSubSubscriber<Event>,
): () => void {
    const unsubscribe = subscribe(event, (...args) => {
        unsubscribe();
        callback(...args);
    });

    return unsubscribe;
}

export function publish<Event extends EPubSubEvent>(
    event: Event,
    ...args: TEventArgs<Event>
): void {
    pubSubPublish(event, (args as unknown[])[0]);
}

export function publishSync<Event extends EPubSubEvent>(
    event: Event,
    ...args: TEventArgs<Event>
): void {
    pubSubPublishSync(event, (args as unknown[])[0]);
}
