const nodeEnv = process.env.NODE_ENV || 'development';
const buildVersion = process.env.BUILD_ID || 'dev';
const buildLang = process.env.BUILD_LANG || 'ru';
const isBuildBundleAnalyzer = process.env.BUILD_BUNDLE_ANALYZER;
const buildAnalyzerMode = process.env.BUILD_ANALIZER_MODE || 'static';
const serverSourceMap = process.env.SERVER_SOURCE_MAP || false;
const isProduction = nodeEnv === 'production';
const isDevelopment = nodeEnv !== 'production';
const hostname = process.env.HOSTNAME;

module.exports = {
    hostname,
    isProduction,
    isDevelopment,
    isBuildBundleAnalyzer,
    buildAnalyzerMode,
    buildLang,
    buildVersion,
    nodeEnv,
    serverSourceMap,
};
