# Яндекс Путешествия (админка отелей)

## Дополнительная документация

-   Инфраструктура в Yandex
    -   [Создание нового приложения](./docs/create-new-yandex-application.md)
    -   TODO - Arc CI
        1. a.yaml
        2. Projects
-   Разное
    -   [Оценка в Story points](https://a.yandex-team.ru/arc/trunk/arcadia/travel/frontend/portal/docs/story-points.md)

## Приложения

-   [Биздев админка](./apps/bizdev-admin)

## Предложения

Большая часть проекта - предложения по подходам

-   Пакетный менеджер - yarn@3

    -   Плагины
        -   typescript - автоматическая установка типов пакетов
        -   workspace-tools - добавляет команду для установки зависимостей только для конкретного пакета
        -   interactive-tools - интерактивный точечный апдейт зависимостей во всех пакетах
    -   workspace
        -   Воркспейс не заставляет использовать только внутренние зависимости через "internal-lib": "workspace:\*"
        -   Поинт про "мёртвые" проекты, которые живут и их не трогают - спорно,
    -   Прозрачнее (выдает больше информации о пакетах, не делает неочевидных сайд-эффектов)

-   Вынос общей логики, лишенной жесткой привязки к бизнесу, в libs

-   Кодогенерация - избавляемся от рутинной работы, пишем за полчаса-час генератор того, на что тратим каждый раз 5-15 минут

    -   Библиотека UI-компонентов - если примем atomic, - легчайше допилим генератор ui-компонентов
    -   API - очень просто генерировать из сваггера, но с ним хз что происходит, не сильно сложнее должна быть генерация для grpc
    -   Feature-sliced
        -   Можно генерировать слайсы на всех основных слоях - entities, features, widgets
        -   Можно генерировать сгруппированные слайсы (ex. entities/train/{train/order/passenger})
        -   Можно генерировать shared/ui для проектных специфичных компонентов (по тому же atomic)
        -   Можно генерировать shared/api сетевой слой

-   Создание UI-Kit по [Atomic design](https://atomicdesign.bradfrost.com/chapter-2/).
    Особенность - высокий уровень абстракции компонентов из-за того, что общий UI-Kit должен реализовывать
    только общие компоненты нашей дизайн-системы

    -   [Атомы - примитивы](./libs/ui/atoms) - атомарные компоненты без композиции других компонентов

        > Исключение - жестко связанная композиция, когда вынос потребителя на уровень
        > выше приведет к несогласованности. Например, компоненты, являющиеся общими
        > для других атомов из-за выноса дубликата
        > (например, [skeleton/TextSkeleton](./libs/ui/atoms/skeleton/text-skeleton.tsx), использующий
        > [skeleton/BaseSkeleton](./libs/ui/atoms/skeleton/base-skeleton.tsx))
        > или низкоуровневые абстракции (например, Portal)

        Примеры:

        -   [Button](./libs/ui/atoms/button)
        -   [Typography](./libs/ui/atoms/typography)

    -   [Молекулы - композиция атомов](./libs/ui/molecules) - реализуют собственную логику и композицию атомов.
        Логика вынесения проста - если составные части нашего компонента являются переиспользуемыми (даже потенциально), -
        его следует располагать на этом уровне, а независимые составные части выносить в слой атомов
    -   [TODO - Организмы - композиция молекул и атомов](./libs/ui/organisms)
    -   Плюсы
        -   Общедоступный подход - не велосипедим дизайн структуры, который нужно объяснять,
            достаточно чуть ли не одной ссылки => понижаем порог входа
        -   Четкая прозрачная структура - при прочтении/поиске компонентов мы всегда знаем базовую специфику компонента
        -   Нужно думать - перед разработкой, мы должны понять, чем является наш новый компонент
        -   Из-за жесткой структуры можно автоматизировать разработку - линтеры, кодогенераторы, анализаторы
        -   Можно шарить на другие проекты
    -   Минусы
        -   Нужно думать :)
        -   Полный переход займёт время

-   Использование [Tailwind](https://tailwindcss.com/) как самого оптимального инструмента для стилизации
    -   Плюсы
        -   Общедоступный подход - есть дока, есть файл с конфигурацией, всё. Никаких велосипедов => понижаем порог входа
        -   Почти полное отсутствие кастомных стилей
        -   Минимальный размер CSS
        -   Скорость сборки (почти ничего не стоит, в отличие от scss)
        -   Скорость разработки (есть порог вхождения) - гораздо быстрее писать стили и видеть результат,
            чем при использовании css модулей. Исключение - кастомные кейсы (например, хитрая анимация) - тут +- так же
        -   Перфоманс - самый нативный способ стилизации, минимальный CSSOM, минимальное количество стилей и классов
        -   Хорошая поддержка IDE
        -   Отличная документация
        -   С минимальными усилиями можно построить лаконичную дизайн-систему кастомизацией конфига под нашу специфику
        -   **Можно внедрять маленькими кусками** - т.к. tailwind просто добавляет классы, не придется делать крупный рефакторинг.
            Например, можно внедрять в процессе реструктурирования UI-компонентов
    -   Минусы
        -   Порог входа - навскидку, привыкание может занять от недели до трёх.
            Это не так страшно, т.к. это просто прыжки в доку, чтобы понять, как добавить правило, но всё же
        -   До полного внедрения будет неконсистентность компонентов (не так больно, если это пойдёт вместе с реструктуризацией)
        -   Кроме ui-компонентов у нас есть куча бизнесовых компонентов, которые тоже как-то стилизованы - а вот это уже надолго
