import { createEffect, createEvent, restore, sample } from 'effector';
import { TmpApi } from '@/shared/api';
import { IHotelInfoParams, IHotelInfoResult } from '@/shared/api/tmp/api.tmp';

const getHotelFx = createEffect(TmpApi.getHotelInfo);

export const hotelRequested = createEvent<IHotelInfoParams>();

export const $params = restore(hotelRequested, {
    hotelCode: '',
    partnerId: '',
});

export const $pending = getHotelFx.pending;
export const $hotel = restore(getHotelFx, {
    hotel_connection_state: 'UNKNOWN',
    slug: '',
    hotel_name: '',
    billing_contract_id: 0,
    billing_client_id: 0,
    paper_agreement: false,
    payments_enabled: false,
    st_ticket: '',
    unpublished_reason: 'UNKNOWN',
    accountant_emails: [],
    contract_person_emails: [],
} as IHotelInfoResult);

sample({
    clock: hotelRequested,
    filter: source => Boolean(source.hotelCode && source.partnerId),
    target: getHotelFx,
});
