import { EPartnerId, SUPPORTED_PARTNERS } from '@/entities/partners';
import useTranslation from 'next-translate/useTranslation';
import { useMemo } from 'react';

export function usePartnersOptions(values = SUPPORTED_PARTNERS) {
    const { t } = useTranslation('partners');

    return useMemo(
        () =>
            values.map(value => ({
                value,
                label: t(
                    `types.${EPartnerId[value]}.label`,
                    {},
                    {
                        default: 'types.unknown.label',
                    },
                ),
            })),
        [values, t],
    );
}
