import { attach } from 'effector/compat';
import { TmpApi } from '@/shared/api';
import { HotelModel, isPublishedHotel } from '@/entities/hotel';
import { createEvent, restore, sample } from 'effector';

const changeConnectionStateFx = attach({
    source: {
        params: HotelModel.$params,
        hotel: HotelModel.$hotel,
    },
    async effect({ params: { partnerId, hotelCode }, hotel }) {
        return TmpApi.changeConnectionState({
            connection_state: isPublishedHotel(hotel) ? 'unpublished' : 'published',
            hotel_code: hotelCode,
            partner_id: partnerId,
        });
    },
});

sample({
    fn: (hotel, { new_state }) => ({
        ...hotel,
        hotel_connection_state: new_state.toLowerCase(),
    }),
    clock: changeConnectionStateFx.doneData,
    source: HotelModel.$hotel,
    target: HotelModel.$hotel,
});

export const toggleStateButtonClicked = createEvent();

sample({
    clock: toggleStateButtonClicked,
    target: changeConnectionStateFx,
});

export const $published = HotelModel.$hotel.map(isPublishedHotel);
export const $pending = changeConnectionStateFx.pending;
export const $error = restore(
    changeConnectionStateFx.failData.map(
        error => (error as any).response?.data.message ?? error.message,
    ),
    null,
);
