import { useEvent, useStore } from 'effector-react';
import { memo } from 'react';
import { Button } from '@yandex-travel/ui/molecules';
import { Text } from '@yandex-travel/ui/atoms';

import * as model from '../model';

export const ChangeHotelConnectionState = memo(() => {
    const error = useStore(model.$error);
    const pending = useStore(model.$pending);
    const published = useStore(model.$published);
    const handleClick = useEvent(model.toggleStateButtonClicked);

    return (
        <>
            <Button
                theme={published ? 'attention' : 'primary'}
                disabled={pending}
                onClick={handleClick}
            >
                {published ? 'Распубликовать' : 'Опубликовать'}
            </Button>
            {error && <Text className="block mt-1 text-red">{error}</Text>}
        </>
    );
});
