import { attach, createEvent, restore, sample } from 'effector';
import { TmpApi } from '@/shared/api';
import { HotelModel } from '@/entities/hotel';

const togglePaymentFx = attach({
    source: HotelModel.$hotel.map(
        ({ payments_enabled, billing_contract_id, billing_client_id }) => ({
            payments_enabled,
            billing_contract_id,
            billing_client_id,
        }),
    ),
    async effect({ payments_enabled, ...params }) {
        return payments_enabled ? TmpApi.stopPayment(params) : TmpApi.resumePayment(params);
    },
});

sample({
    fn: (hotel, { payments_enabled }) => ({
        ...hotel,
        payments_enabled,
    }),
    clock: togglePaymentFx.doneData,
    source: HotelModel.$hotel,
    target: HotelModel.$hotel,
});

export const togglePaymentClicked = createEvent();

sample({
    clock: togglePaymentClicked,
    target: togglePaymentFx,
});

export const $pending = togglePaymentFx.pending;
export const $paymentEnabled = HotelModel.$hotel.map(hotel => hotel.payments_enabled);

export const $error = restore(
    togglePaymentFx.failData.map(error => (error as any).response?.data?.message ?? error.message),
    null,
).reset([HotelModel.hotelRequested, togglePaymentFx.done]);
