import { useEvent, useStore } from 'effector-react';
import { memo } from 'react';
import { Text } from '@yandex-travel/ui/atoms';
import { Button } from '@yandex-travel/ui/molecules';

import * as model from '../model';

export const ChangeHotelPayment = memo(() => {
    const error = useStore(model.$error);
    const enabled = useStore(model.$paymentEnabled);
    const pending = useStore(model.$pending);
    const handleClick = useEvent(model.togglePaymentClicked);

    return (
        <div>
            <Button
                theme={enabled ? 'attention' : 'primary'}
                disabled={pending}
                onClick={handleClick}
            >
                {enabled ? 'Остановить выплаты' : 'Возобновить выплаты'}
            </Button>
            {error && (
                <Text className="block mt-1 text-red" size="md">
                    {error}
                </Text>
            )}
        </div>
    );
});
