import { memo } from 'react';
import { useForm } from 'react-hook-form';
import { Form } from '@/shared/ui/atoms';
import { useEvent, useStore } from 'effector-react';
import { IHotelInfoParams } from '@/shared/api/tmp/api.tmp';
import { Field } from '@/shared/ui/molecules';
import { HotelModel } from '@/entities/hotel';
import { usePartnersOptions } from '@/entities/partners';
import useTranslation from 'next-translate/useTranslation';
import { Button, Input } from '@yandex-travel/ui/molecules';
import { Select } from '@yandex-travel/ui/organisms';

import * as model from '../model';

export const IdentifyHotel = memo(() => {
    const { t } = useTranslation('hotel');

    const form = useForm<IHotelInfoParams>();
    const pending = useStore(HotelModel.$pending);
    const handleSubmit = useEvent(model.formSubmitted);

    const partners = usePartnersOptions();

    return (
        <Form form={form} onSubmit={handleSubmit} className="space-y-1">
            <div className="grid grid-cols-2 gap-6">
                <Field name="partnerId" label={t('identify.fields.partnerId.label')} required>
                    <Select
                        data={partners}
                        theme="outlined"
                        placeholder={t('identify.fields.partnerId.placeholder')}
                    />
                </Field>
                <Field name="hotelCode" label={t('identify.fields.hotelCode.label')} required>
                    <Input fullWidth />
                </Field>
            </div>
            <Button theme="primary" type="submit" disabled={pending}>
                {t('identify.submit')}
            </Button>
        </Form>
    );
});
