import { createEffect, createEvent, createStore, EventPayload, restore, sample } from 'effector';
import { TmpApi } from '@/shared/api';
import { some } from 'patronum';
import { HotelModel } from '@/entities/hotel';

import { MoveHotelsOrderParams } from '@/features/move-hotel-orders/types';

export const submitted = createEvent<MoveHotelsOrderParams>();

const moveHotelOrderFx = createEffect(TmpApi.moveHotelOrder);

const $ordersQueue = restore(
    submitted.map(params => params.orders),
    [],
)
    .reset([HotelModel.hotelRequested])
    // По завершении эффекта удаляем из очереди заказ, с которым он был вызван
    .on(moveHotelOrderFx.finally, prev => prev.slice(1));

export const $results = createStore<EventPayload<typeof moveHotelOrderFx.finally>[]>([])
    .reset([submitted, HotelModel.hotelRequested])
    .on(moveHotelOrderFx.finally, (prev, result) => prev.concat(result));

export const $pending = some({
    stores: [moveHotelOrderFx.pending, $ordersQueue.map(queue => queue.length > 0)],
    predicate: true,
});

/**
 * Когда меняется очередь - берем первый элемент, поля из submitted и запускаем эффект
 */
sample({
    fn: ({ contract_id, client_id }, orders) => ({
        ...orders[0],
        contract_id,
        client_id,
    }),
    clock: $ordersQueue,
    source: submitted,
    filter: (_, orders) => orders.length > 0,
    target: moveHotelOrderFx,
});
