import { NextRequest, NextResponse } from 'next/server';
import {
    addYandexSessionIdCookie,
    addYandexUidCookie,
    getNextMiddlewareLogger,
    getNextMiddlewareUatraits,
    isNextMiddlewareAuthorized,
} from 'yandex-net/next/middleware';

import { getPassportAuthUrl, logger } from '@/shared/lib';

import { uatraitsClient } from '@/app/server/network';

export async function middleware(req: NextRequest): Promise<NextResponse> {
    const res = NextResponse.next();
    const log = getNextMiddlewareLogger(req, logger);

    if (req.nextUrl.pathname.startsWith('/api/ping') || req.nextUrl.pathname !== '/') {
        return res;
    }

    log.info(`Request: %s`, req.url);

    // TODO Возможно, как-то упростить
    const uatraits = await getNextMiddlewareUatraits(req, uatraitsClient);

    addYandexUidCookie(req, res, uatraits);
    // TODO Вынести в enum TravelCookieName or smth like
    addYandexSessionIdCookie(req, res, 'ya_travel_uid');

    if (!isNextMiddlewareAuthorized(req)) {
        log.warn(`Unauthorized: redirect to "${getPassportAuthUrl(req.nextUrl.clone())}"`);

        // TODO Вынести в yandex-net
        return NextResponse.redirect(getPassportAuthUrl(req.nextUrl.clone()));
    }

    return res;
}
