const path = require('path');
const nextTranslate = require('next-translate');
const { createNextConfig, env } = require('config/nextjs');

/**
 * @type {import('next').NextConfig}
 */
const configuration = {
    eslint: {
        ignoreDuringBuilds: true,
    },
    compiler: {
        reactRemoveProperties: {
            properties: ['^data-qa$', '^testId$'],
        },
    },
    poweredByHeader: false,
    generateEtags: false,
    experimental: {
        // @see https://nextjs.org/docs/advanced-features/output-file-tracing#caveats
        outputFileTracingRoot: path.join(__dirname, '../../'),
        outputStandalone: true,
        reactRoot: false,
        externalDir: false,
        esmExternals: false,
    },
};

module.exports = createNextConfig(
    {
        cwd: __dirname,
        workspaceDependencies: ['@yandex-travel/ui', 'yandex-net', 'logger'],
        analyzer: {
            enabled: env.bool('ANALYZE'),
            detailed: true,
        },
        plugins: [nextTranslate],
    },
    configuration,
);
