import { Text } from '@yandex-travel/ui/atoms';
import { Button } from '@yandex-travel/ui/molecules';
import Link from 'next/link';
import { ReactElement } from 'react';

export default function Error404(): ReactElement {
    return (
        <main className="max-w-3xl text-center mx-auto pt-60">
            <Text as="div" size="xxl" className="mb-8">
                Страница не найдена
            </Text>
            <Link href="/">
                <a>
                    <Button theme="primary" size="lg" className="w-full max-w-sm mx-auto">
                        На главную
                    </Button>
                </a>
            </Link>
        </main>
    );
}
