import { Head, Html, Main, NextScript } from 'next/document';
import { ReactElement } from 'react';

export default function Document(): ReactElement {
    return (
        <Html lang="ru">
            <Head>
                <link rel="shortcut icon" type="image/x-icon" href="/favicons/favicon.ico" />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="16x16"
                    href="/favicons/favicon-16x16.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="32x32"
                    href="/favicons/favicon-32x32.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="57x57"
                    href="/favicons/favicon-57x57.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="64x64"
                    href="/favicons/favicon-64x64.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="76x76"
                    href="/favicons/favicon-76x76.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="120x120"
                    href="/favicons/favicon-120x120.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="144x144"
                    href="/favicons/favicon-144x144.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="152x152"
                    href="/favicons/favicon-152x152.png"
                />
                <link
                    rel="icon"
                    type="image/png"
                    sizes="180x180"
                    href="/favicons/favicon-180x180.png"
                />
                <link rel="apple-touch-icon" sizes="57x57" href="/favicons/favicon-57x57.png" />
                <link rel="apple-touch-icon" sizes="60x60" href="/favicons/favicon-60x60.png" />
                <link rel="apple-touch-icon" sizes="76x76" href="/favicons/favicon-76x76.png" />
                <link rel="apple-touch-icon" sizes="114x114" href="/favicons/favicon-114x114.png" />
                <link rel="apple-touch-icon" sizes="120x120" href="/favicons/favicon-120x120.png" />
                <link rel="apple-touch-icon" sizes="144x144" href="/favicons/favicon-144x144.png" />
                <link rel="apple-touch-icon" sizes="152x152" href="/favicons/favicon-152x152.png" />
                <link rel="apple-touch-icon" sizes="180x180" href="/favicons/favicon-180x180.png" />

                <link
                    rel="preload"
                    as="font"
                    type="font/woff2"
                    href="//yastat.net/s3/home/fonts/ys/1/text-regular.woff2"
                    crossOrigin="anonymous"
                />
                <link
                    rel="preload"
                    as="font"
                    type="font/woff2"
                    href="//yastat.net/s3/home/fonts/ys/1/text-medium.woff2"
                    crossOrigin="anonymous"
                />
                <link
                    rel="preload"
                    as="font"
                    type="font/woff2"
                    href="//yastat.net/s3/home/fonts/ys/1/text-bold.woff2"
                    crossOrigin="anonymous"
                />
            </Head>
            <body>
                <Main />
                <NextScript />
            </body>
        </Html>
    );
}
