import { Card, Text } from '@yandex-travel/ui/atoms';
import Head from 'next/head';
import { ReactElement } from 'react';

import { HotelView } from '@/entities/hotel';

import { ChangeHotelConnectionState } from '@/features/change-hotel-connection-state';
import { ChangeHotelPayment } from '@/features/change-hotel-payment';
import { IdentifyHotel } from '@/features/identify-hotel';
import { MoveHotelOrdersView } from '@/features/move-hotel-orders';

import { MainLayout } from '@/widgets/layout';

export default function IndexPage(): ReactElement {
    return (
        <>
            <Head>
                <title>Биздев админка - поиск отеля</title>
            </Head>
            <div className="space-y-8">
                <Text size="xxl">Выбор отеля</Text>
                <Card>
                    <IdentifyHotel />
                </Card>
                <HotelView
                    afterNode={
                        <>
                            <Text size="xxl">Перенос брони</Text>
                            <Card>
                                <MoveHotelOrdersView />
                            </Card>
                        </>
                    }
                >
                    <div className="h-[1px] my-4 bg-gray-100" />
                    <div className="flex gap-4">
                        <ChangeHotelPayment />
                        <ChangeHotelConnectionState />
                    </div>
                </HotelView>
            </div>
        </>
    );
}

IndexPage.LayoutComponent = MainLayout;
