import axios, { Axios } from 'axios';

// лол
import { compactObject } from 'yandex-net/core/shared';

export interface IStopPaymentParams {
    billing_client_id: number;
    billing_contract_id?: number | null;
}

export interface IStopPaymentResponse {
    billing_client_id: number;
    resume_result: string;
    payments_enabled: boolean;
}

export interface IResumePaymentParams {
    billing_client_id: number;
    billing_contract_id?: number | null;
}

export interface IResumePaymentResponse {
    billing_client_id: number;
    payments_enabled: boolean;
    resume_result: string;
}

export interface IHotelInfoParams {
    partnerId: string | number;
    hotelCode: string | number;
}

export type THotelConnectionState = string;
export type TUnpublishedReason = string;
export interface IHotelInfoResult {
    hotel_connection_state: THotelConnectionState;
    permalink?: number | string;
    slug: string;
    hotel_name: string;
    billing_contract_id: number;
    billing_client_id: number;
    paper_agreement: boolean;
    payments_enabled?: boolean;
    st_ticket: string;
    unpublished_reason: TUnpublishedReason;
    accountant_emails: string[];
    contract_person_emails: string[];
}

export interface IMoveHotelOrderParams {
    order_id?: string;
    pretty_id: string;
    client_id: number | string;
    contract_id: number | string;
}

export interface IMoveHotelOrderResult {
    move_result?: 'ok';
}

export interface IChangeHotelConnectionStateParams {
    partner_id: number | string;
    hotel_code: number | string;
    connection_state: 'published' | 'unpublished';
}

export interface IChangeHotelConnectionStateResult {
    previous_state: 'UNPUBLISHED' | 'PUBLISHED';
    new_state: 'UNPUBLISHED' | 'PUBLISHED';
}

export class ApiTmp {
    readonly instance: Axios;

    constructor({ baseURL }: { baseURL: string }) {
        this.instance = axios.create({ baseURL });
    }

    moveHotelOrder = (params: IMoveHotelOrderParams): Promise<IMoveHotelOrderResult> =>
        this.instance
            .post(`/api/admin/v1/move_hotel_order_to_new_contract`, params)
            .then(r => r.data);

    getHotelInfo = (params: IHotelInfoParams): Promise<IHotelInfoResult> =>
        this.instance
            .get(`/api/administrator/get_hotel_connection`, {
                params: compactObject(params),
            })
            .then(r => r.data);

    changeConnectionState = (
        params: IChangeHotelConnectionStateParams,
    ): Promise<IChangeHotelConnectionStateResult> => {
        return this.instance
            .post(`/api/administrator/change_hotel_connection_state`, compactObject(params))
            .then(r => r.data);
    };

    stopPayment = (params: IStopPaymentParams): Promise<IStopPaymentResponse> => {
        return this.instance.post(`/api/admin/v1/stop_partner_payments`, params).then(r => r.data);
    };

    resumePayment = (params: IResumePaymentParams): Promise<IResumePaymentResponse> => {
        return this.instance
            .post(`/api/admin/v1/resume_partner_payments`, params)
            .then(r => r.data);
    };
}
