import { getTvmEnvironmentConfig, mergeConfig } from 'yandex-net/core/config';
import { ITvmDependency } from 'yandex-net/core/tvm';

import { logger } from '@/shared/lib';

export enum CookieName {
    SESSION_ID = 'ya_travel_uid',
}

export const ServerConfig = mergeConfig(
    {
        dev: process.env.NODE_ENV === 'development',
        local: process.env.APPLICATION_ENV === 'local',
        tvm: {
            url: 'Not provided',
            token: 'Not provided',
            dependencies: [] as ITvmDependency<'api' | 'blackbox'>[],
        },
        blackbox: {
            url: 'Not provided',
            defaults: {
                get_public_id: true,
                get_public_name: true,
                aliases: ['portal', 'social'],
                attributes: ['account.normalized_login'],
            },
        },
        uatrails: {},
        api: {
            orders: 'Not provided',
        },
        localBlackboxProxyIP: process.env.LOCAL_BLACKBOX_PROXY_USER_IP!,
    },
    // Пусть собранное приложение всегда ходит в актуальный ЧЯ
    process.env.NODE_ENV === 'production' && {
        blackbox: {
            url: 'https://blackbox.yandex-team.ru',
        },
    },
    // Локально ходим в проксю ЧЯ и локальный TVM
    process.env.APPLICATION_ENV === 'local' && {
        tvm: {
            url: 'http://localhost:9911',
            token: '41111111111111111111111111111111',
        },
        blackbox: {
            url: process.env.LOCAL_BLACKBOX_PROXY_BASE_URL,
        },
    },
    // Локально и в тестинге ходим в тестовый АПИ
    (process.env.APPLICATION_ENV === 'testing' || process.env.APPLICATION_ENV === 'local') && {
        api: {
            orders: 'https://api.travel-balancer-test.yandex.net',
        },
        tvm: {
            dependencies: [
                {
                    name: 'blackbox',
                    id: 223,
                },
                {
                    name: 'api',
                    id: 2002548,
                },
            ],
        },
    },
    process.env.APPLICATION_ENV === 'production' && {
        api: {
            orders: 'https://api-prod.travel-hotels.yandex.net',
        },
        tvm: {
            dependencies: [
                {
                    name: 'blackbox',
                    id: 223,
                },
                {
                    name: 'api',
                    id: 2002546,
                },
            ],
        },
    },
    // Любое не локальное окружение
    process.env.APPLICATION_ENV !== 'local' && {
        tvm: {
            ...getTvmEnvironmentConfig(),
        },
    },
);

logger.info({ ServerConfig }, 'server config');
