import { Logger, LoggerLevel } from 'logger';
import { JsonStream } from 'logger/stream/json';
import { YandexDeployStream } from 'logger/stream/yandex-deploy';
import { NodeDevStream } from 'logger/stream/node-dev';

export const logger = new Logger({
    name: 'bizdev-admin',
    streams: [
        {
            level: LoggerLevel.info,
            // TODO Добавить поддержку нормальных дев-стримов для браузера и для ноды
            stream:
                typeof window === 'undefined'
                    ? process.env.NODE_ENV === 'development'
                        ? new NodeDevStream()
                        : new YandexDeployStream()
                    : new JsonStream(),
        },
    ],
});
